% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_postcode.R
\name{nearest_postcode}
\alias{nearest_postcode}
\title{Nearest postcode}
\usage{
nearest_postcode(postcode, limit = 10, radius = 100)
}
\arguments{
\item{postcode}{A string. Valid UK postcode.}

\item{limit}{A string or integer. Limits number of postcodes matches to return. Defaults to 10. Needs to be lower than 100.}

\item{radius}{Limits number of postcodes matches to return. Defaults to 100m. Needs to be less than 2,000m.}
}
\value{
A list of geographic properties of the nearest postcode.
}
\description{
Returns nearest postcodes for a given postcode.
The search is based on the relative distance of the postcode centroid.
}
\examples{
\donttest{
nearest_postcode("EC1Y 8LX")
nearest_postcode("EC1Y 8LX", limit = 11)
nearest_postcode("EC1Y 8LX", limit = 12, radius = 200)
}

}
