/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.StreamWorker;
import com.portfolioeffect.quant.client.message.CalculationStatusMessage;
import com.portfolioeffect.quant.client.message.TransmitDataListMessage;
import com.portfolioeffect.quant.client.message.TransmitDataRequest;
import com.portfolioeffect.quant.client.message.TransmitDataResponse;
import com.portfolioeffect.quant.client.message.ValidationResponse;
import com.portfolioeffect.quant.client.message.util.ClientRequestMessageFactory;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageFactory;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageParser;
import com.portfolioeffect.quant.client.model.ConnectFailedException;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.DateTimeUtil;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.iq80.snappy.Snappy;
import org.openfast.Message;

public class RequestToServer {
    public static final String STREAM_IS_ALREADY_RUNNING = "Stream is already running";
    private static final int USER_LAYER_TIMEOUT_SECONDS_ESTIMATE = 300;
    private static final int MAX_BLOCK_DIMENSION = 100000;
    private static final int DATA_TRANSMIT_TIMEOUT_SECONDS_ESTIMATE = 300;

    public static Metric validateString(ClientConnection client, String requestString) throws Exception {
        if (client.isStreamEnabled()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        if (!client.isPureAscii(requestString)) {
            return new Metric("Request String contains a non-ASCII character.");
        }
        String[] paramList = new String[]{};
        Message msg = ClientRequestMessageFactory.createValidationRequest(client.getTemplateRegistry(), requestString, client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message responseMsg = client.sendAndAwaitResponse(msg, 300);
        ValidationResponse response = ServerResponseMessageParser.parseValidationResponse(responseMsg);
        if (!response.getMsgType().equals("OK")) {
            return new Metric(response.getMsgBody());
        }
        Type mapType = new TypeToken<String[]>(){}.getType();
        Gson gson = new Gson();
        paramList = (String[])gson.fromJson(response.getMsgBody(), mapType);
        Metric result = new Metric();
        ArrayCache pL = new ArrayCache(paramList);
        result.setData("positions", pL);
        return result;
    }

    public static Metric transmitQuantity(ClientConnection client, String assetName, int[] dataInt, long[] time) throws Exception {
        if (client.isStreamEnabled()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        boolean isFirstBlock = true;
        int position = 0;
        for (int i = 0; i < time.length / 100000; ++i) {
            int[] dataTransmit = new int[100000];
            long[] timeTransmit = new long[100000];
            System.arraycopy(time, position, timeTransmit, 0, 100000);
            System.arraycopy(dataInt, position, dataTransmit, 0, 100000);
            String type = "QUANTITY";
            if (!isFirstBlock) {
                type = type + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(client.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = client.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            position += 100000;
            if (response.getMsgType().equals("OK")) continue;
            throw new Exception(response.getMsgBody());
        }
        if (time.length % 100000 != 0) {
            int[] dataTransmit = new int[time.length % 100000];
            long[] timeTransmit = new long[time.length % 100000];
            System.arraycopy(time, position, timeTransmit, 0, time.length % 100000);
            System.arraycopy(dataInt, position, dataTransmit, 0, dataInt.length % 100000);
            String type = "QUANTITY";
            if (!isFirstBlock) {
                type = type + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(client.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = client.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
        }
        Metric result = new Metric();
        result.setMessage("NON");
        return result;
    }

    public static boolean transmitStreamQuantity(ClientConnection client, String assetName, int quantity, long time) throws Exception {
        if (!client.isStreamRuning()) {
            return false;
        }
        int[] dataTransmit = new int[]{quantity};
        long[] timeTransmit = new long[]{time};
        String type = "QUANTITY:stream";
        String request = assetName;
        Message msg = ServerResponseMessageFactory.createTransmitDataRequest(client.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        client.send(msg);
        return true;
    }

    public static Metric transmitUserPrice(ClientConnection client, String assetName, float[] dataFloat, long[] time) throws Exception {
        if (client.isStreamEnabled()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        boolean isFirstBlock = true;
        int position = 0;
        for (int i = 0; i < time.length / 100000; ++i) {
            float[] dataTransmit = new float[100000];
            long[] timeTransmit = new long[100000];
            System.arraycopy(time, position, timeTransmit, 0, 100000);
            System.arraycopy(dataFloat, position, dataTransmit, 0, 100000);
            String type = "USER_PRICE";
            if (!isFirstBlock) {
                type = type + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(client.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = client.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            position += 100000;
            if (response.getMsgType().equals("OK")) continue;
            throw new Exception(response.getMsgBody());
        }
        if (time.length % 100000 != 0) {
            float[] dataTransmit = new float[time.length % 100000];
            long[] timeTransmit = new long[time.length % 100000];
            System.arraycopy(time, position, timeTransmit, 0, time.length % 100000);
            System.arraycopy(dataFloat, position, dataTransmit, 0, time.length % 100000);
            String type = "USER_PRICE";
            if (!isFirstBlock) {
                type = type + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(client.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = client.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
        }
        Metric result = new Metric();
        result.setMessage("NON");
        return result;
    }

    public static Metric transmitDataList(ClientConnection client, String fromTime, String toTime, ArrayList<String> dataList, String windowLength, String priceSamplingInterval, String momentsModel, String trainingPeriodEnabled) throws Exception {
        if (client.isStreamEnabled()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        for (String e : dataList) {
            boolean isHystoryPrice;
            if (!client.isPureAscii(e)) {
                return new Metric("Position name String contains a non-ASCII character.");
            }
            boolean bl = isHystoryPrice = e.contains("h-") || e.contains("hI-");
            if (isHystoryPrice && fromTime.contains("#")) {
                return new Metric("fromTime is not set");
            }
            if (!isHystoryPrice || !toTime.contains("#")) continue;
            return new Metric("toTime is not set");
        }
        String requestType = "CHECK_DATA";
        TransmitDataListMessage dataListMessage = new TransmitDataListMessage(dataList, windowLength, fromTime, toTime, priceSamplingInterval, momentsModel, trainingPeriodEnabled);
        Gson gson = new Gson();
        Type mapType = new TypeToken<TransmitDataListMessage>(){}.getType();
        String request = gson.toJson((Object)dataListMessage, mapType);
        Message msg = ServerResponseMessageFactory.createTransmitDataRequest(client.getTemplateRegistry(), requestType, request, client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message responseMsg = client.sendAndAwaitResponse(msg, 300);
        TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
        if (response.getMsgType().equals("OK")) {
            Metric result = new Metric();
            result.setMessage(response.getMsgBody());
            return result;
        }
        return new Metric(response.getMsgBody());
    }

    public static Metric calculateEstimator(ClientConnection client, String metricType) throws Exception {
        if (client.isStreamEnabled()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        HashMap<String, String> info = new HashMap<String, String>();
        ArrayCache resultValueList = null;
        ArrayCache resultTimeList = null;
        boolean isRun = true;
        boolean isFirstBlock = true;
        double percent = 0.0;
        int[] dimensions = null;
        client.printCompletionStatus(percent);
        while (isRun) {
            Message responseMsg;
            Message msg;
            if (isFirstBlock) {
                resultValueList = new ArrayCache(ArrayCacheType.DOUBLE_VECTOR);
                resultTimeList = new ArrayCache(ArrayCacheType.LONG_VECTOR);
                msg = ClientRequestMessageFactory.createNonparametricComputeRequest(client.getTemplateRegistry(), metricType, "", new double[1], new int[1], client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = client.sendAndAwaitResponse(msg, 300);
                isFirstBlock = false;
            } else {
                msg = ClientRequestMessageFactory.createNonparametricComputeRequest(client.getTemplateRegistry(), metricType, "#NEXT#", new double[1], new int[1], client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = client.sendAndAwaitResponse(msg, 300);
            }
            TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
            if (response.getMsgType().contains("OK")) {
                Gson gson = new Gson();
                Type mapType = new TypeToken<CalculationStatusMessage>(){}.getType();
                CalculationStatusMessage statusMessg = (CalculationStatusMessage)gson.fromJson(response.getMsgType(), mapType);
                dimensions = statusMessg.getDimension();
                float[] data = response.getDataFloat();
                long[] time = response.getTime();
                resultValueList.writeAsDouble(data);
                resultTimeList.write(time);
                percent = Double.valueOf(response.getMsgBody());
                client.printCompletionStatus(percent);
                if (!response.getMsgType().contains("STOP")) continue;
                info = statusMessg.getResultInfo();
                isRun = false;
                continue;
            }
            throw new Exception(response.getMsgBody());
        }
        if (dimensions != null) {
            resultValueList.setDimensions(dimensions);
        }
        Metric result = new Metric();
        result.setData("value", resultValueList);
        result.setData("time", resultTimeList);
        result.setInfo(info);
        return result;
    }

    public static Metric calculatePortfolioMetric(ClientConnection client, String metricType, String indexPosition, ArrayList<String> positionList, String params) throws Exception {
        if (metricType.contains("stream")) {
            if (client.isStreamEnabled()) {
                return new Metric(STREAM_IS_ALREADY_RUNNING);
            }
            client.setStreamEnabled(true);
        }
        HashMap<String, String> info = new HashMap<String, String>();
        boolean isRun = true;
        boolean isFirstBlock = true;
        double percent = 0.0;
        int[] dimensions = null;
        client.printCompletionStatus(percent);
        ArrayCache[] batchValues = null;
        ArrayCache[] batchValuesTime = null;
        while (isRun) {
            Message responseMsg;
            if (isFirstBlock) {
                if (indexPosition.length() != 0) {
                    positionList.add(0, indexPosition);
                }
                Gson gson = new Gson();
                String request = gson.toJson(positionList);
                if (client.isDebugModeEnabled()) {
                    Console.writeln("Request--->");
                    Console.writeln(metricType);
                    Console.writeln(request);
                    Console.writeln(params);
                    Console.writeln(">---");
                }
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(client.getTemplateRegistry(), metricType, request, params, client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = client.sendAndAwaitResponse(msg, 300);
            } else {
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(client.getTemplateRegistry(), metricType, "#NEXT#", "", client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = client.sendAndAwaitResponse(msg, 300);
            }
            TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
            if (response.getMsgType().contains("OK")) {
                int m;
                int k;
                int len;
                int k2;
                Gson gson = new Gson();
                Type mapType = new TypeToken<CalculationStatusMessage>(){}.getType();
                CalculationStatusMessage statusMessg = (CalculationStatusMessage)gson.fromJson(response.getMsgType(), mapType);
                dimensions = statusMessg.getDimension();
                if (dimensions.length == 0) {
                    dimensions = new int[]{1};
                }
                float[] data = response.getDataFloat();
                long[] time = response.getTime();
                if (client.isDebugModeEnabled()) {
                    if (data.length > 0) {
                        Console.writeln("RECEIVED DATA BLOCK(" + data.length + "): " + data[0] + "\t" + data[data.length - 1]);
                    }
                    if (time.length > 0) {
                        Console.writeln("RECEIVED TIME BLOCK(" + time.length + "): " + new Timestamp(time[0] + DateTimeUtil.CLIENT_TIME_DELTA) + "\t" + new Timestamp(time[time.length - 1] + DateTimeUtil.CLIENT_TIME_DELTA));
                    }
                }
                if (isFirstBlock) {
                    batchValues = new ArrayCache[dimensions.length];
                    for (int i = 0; i < dimensions.length; ++i) {
                        batchValues[i] = dimensions[i] == 1 ? new ArrayCache(ArrayCacheType.DOUBLE_VECTOR) : new ArrayCache(ArrayCacheType.DOUBLE_MATRIX);
                        batchValues[i].setDimensions(new int[]{dimensions[i]});
                    }
                    batchValuesTime = new ArrayCache[batchValues.length];
                    for (k2 = 0; k2 < batchValues.length; ++k2) {
                        batchValuesTime[k2] = new ArrayCache(ArrayCacheType.LONG_VECTOR);
                    }
                    for (k2 = 0; k2 < batchValues.length; ++k2) {
                        batchValuesTime[k2].lockToWrite();
                        batchValues[k2].lockToWrite();
                    }
                    len = 0;
                    while (len < data.length) {
                        for (k = 0; k < dimensions.length; ++k) {
                            for (m = 0; m < dimensions[k]; ++m) {
                                batchValues[k].writeNextDouble(data[len]);
                                ++len;
                            }
                        }
                    }
                    for (k = 0; k < batchValues.length; ++k) {
                        batchValuesTime[k].writeNextLong(time);
                    }
                    for (k = 0; k < batchValues.length; ++k) {
                        batchValuesTime[k].unlockToWrite();
                        batchValues[k].unlockToWrite();
                    }
                    isFirstBlock = false;
                } else {
                    for (k2 = 0; k2 < batchValues.length; ++k2) {
                        batchValuesTime[k2].lockToWrite();
                        batchValues[k2].lockToWrite();
                    }
                    for (k2 = 0; k2 < batchValues.length; ++k2) {
                        batchValuesTime[k2].writeNextLong(time);
                    }
                    len = 0;
                    while (len < data.length) {
                        for (k = 0; k < dimensions.length; ++k) {
                            for (m = 0; m < dimensions[k]; ++m) {
                                batchValues[k].writeNextDouble(data[len]);
                                ++len;
                            }
                        }
                    }
                    for (k = 0; k < batchValues.length; ++k) {
                        batchValuesTime[k].unlockToWrite();
                        batchValues[k].unlockToWrite();
                    }
                }
                percent = Double.valueOf(response.getMsgBody());
                client.printCompletionStatus(percent);
                if (client.isStreamEnabled() && percent >= 1.0) {
                    StreamWorker streamWoker = new StreamWorker(client, batchValues, batchValuesTime, dimensions);
                    new Thread(streamWoker).start();
                    info = statusMessg.getResultInfo();
                    isRun = false;
                }
                if (!response.getMsgType().contains("STOP")) continue;
                info = statusMessg.getResultInfo();
                isRun = false;
                continue;
            }
            client.setStreamEnabled(false);
            throw new Exception(response.getMsgBody());
        }
        Metric result = new Metric();
        result.setData("values", batchValues);
        result.setData("times", batchValuesTime);
        result.setInfo(info);
        return result;
    }

    public static Metric getAllSymbolsList(ClientConnection client) throws Exception {
        Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(client.getTemplateRegistry(), "ALL_SYMBOLS", "", "", client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message responseMsg = client.sendAndAwaitResponse(msg, 300);
        TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
        Metric result = new Metric();
        if (!response.getMsgType().contains("OK")) {
            throw new Exception(response.getMsgBody());
        }
        byte[] data = response.getDataFloatByte();
        data = Snappy.uncompress((byte[])data, (int)0, (int)data.length);
        Map map = (Map)SerializationUtils.deserialize((byte[])data);
        ArrayCache id = new ArrayCache((String[])map.get("id"));
        ArrayCache description = new ArrayCache((String[])map.get("description"));
        ArrayCache exchange = new ArrayCache((String[])map.get("exchange"));
        result.setData("id", id);
        result.setData("description", description);
        result.setData("exchange", exchange);
        return result;
    }

    public static Metric getComputeTimeLeft(ClientConnection client) {
        for (int i = 0; i < 3; ++i) {
            try {
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(client.getTemplateRegistry(), "TIME_LEFT", "", "", client.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                Message responseMsg = client.sendAndAwaitResponse(msg, 300);
                TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
                Metric result = new Metric();
                if (!response.getMsgType().contains("OK")) {
                    throw new Exception(response.getMsgBody());
                }
                String[] data = response.getMsgBody().split("#");
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("timeLeft", data[0]);
                info.put("timeMax", data[1]);
                result.setInfo(info);
                return result;
            }
            catch (Exception e) {
                Metric result = RequestToServer.processException(client, e);
                if (result == null) continue;
                return result;
            }
        }
        return new Metric("Failed to complete estimation procedure - Server request failed due to a timeout.");
    }

    private static Metric processException(ClientConnection client, Exception e) {
        if (e instanceof ConnectFailedException) {
            Metric isRestarted = client.restart();
            if (isRestarted.hasError()) {
                client.resetProgressBar();
                return new Metric(isRestarted.getErrorMessage());
            }
            return null;
        }
        if (e.getMessage() == null || e.getMessage().contains("No data in cache") || e.getMessage().contains("null")) {
            Metric isRestarted = client.restart();
            if (isRestarted.hasError()) {
                client.resetProgressBar();
                return new Metric(isRestarted.getErrorMessage());
            }
            return null;
        }
        if (e.getMessage() == null) {
            Console.writeStackTrace(e);
            return new Metric("Unknown error.");
        }
        client.resetProgressBar();
        return new Metric(e.getMessage());
    }
}

