/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.openfast.BitVectorBuilder;
import org.openfast.BitVectorReader;
import org.openfast.Context;
import org.openfast.FieldValue;
import org.openfast.QName;
import org.openfast.template.ComposedValueConverter;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.Scalar;
import org.openfast.template.type.Type;

public class ComposedScalar
extends Field {
    private static final long serialVersionUID = 1L;
    private static final Class ScalarValueType = null;
    private Scalar[] fields;
    private ComposedValueConverter valueConverter;
    private Type type;
    private FieldValue[] values;

    public ComposedScalar(String name, Type type, Scalar[] fields, boolean optional, ComposedValueConverter valueConverter) {
        this(new QName(name), type, fields, optional, valueConverter);
    }

    public ComposedScalar(QName name, Type type, Scalar[] fields, boolean optional, ComposedValueConverter valueConverter) {
        super(name, optional);
        this.fields = fields;
        this.valueConverter = valueConverter;
        this.type = type;
        this.values = new FieldValue[fields.length];
    }

    public FieldValue createValue(String value) {
        return this.type.getValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldValue decode(InputStream in, Group template, Context context, BitVectorReader presenceMapReader) {
        FieldValue[] fieldValueArray = this.values;
        synchronized (this.values) {
            Arrays.fill(this.values, null);
            int i = 0;
            while (true) {
                if (i >= this.fields.length) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return this.valueConverter.compose(this.values);
                }
                this.values[i] = this.fields[i].decode(in, template, context, presenceMapReader);
                if (i == 0 && this.values[0] == null) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return null;
                }
                ++i;
            }
        }
    }

    public byte[] encode(FieldValue value, Group template, Context context, BitVectorBuilder presenceMapBuilder) {
        if (value == null) {
            return this.fields[0].encode(null, template, context, presenceMapBuilder);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.fields.length * 8);
        FieldValue[] values = this.valueConverter.split(value);
        int i = 0;
        while (i < this.fields.length) {
            try {
                buffer.write(this.fields[i].encode(values[i], template, context, presenceMapBuilder));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return buffer.toByteArray();
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public Class getValueType() {
        return ScalarValueType;
    }

    public boolean isPresenceMapBitSet(byte[] encoding, FieldValue fieldValue) {
        return false;
    }

    public boolean usesPresenceMapBit() {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].usesPresenceMapBit()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Type getType() {
        return this.type;
    }

    public Scalar[] getFields() {
        return this.fields;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(ComposedScalar.class)) {
            return false;
        }
        ComposedScalar other = (ComposedScalar)obj;
        if (other.fields.length != this.fields.length) {
            return false;
        }
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        int i = 0;
        while (i < this.fields.length) {
            if (!other.fields[i].getType().equals(this.fields[i].getType())) {
                return false;
            }
            if (!other.fields[i].getTypeCodec().equals(this.fields[i].getTypeCodec())) {
                return false;
            }
            if (!other.fields[i].getOperator().equals((Object)this.fields[i].getOperator())) {
                return false;
            }
            if (!other.fields[i].getOperatorCodec().equals(this.fields[i].getOperatorCodec())) {
                return false;
            }
            if (!other.fields[i].getDefaultValue().equals(this.fields[i].getDefaultValue())) {
                return false;
            }
            if (!other.fields[i].getDictionary().equals(this.fields[i].getDictionary())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Composed {");
        int i = 0;
        while (i < this.fields.length) {
            builder.append(this.fields[i].toString()).append(", ");
            ++i;
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.append("}").toString();
    }
}

