/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.result;

import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MethodResult {
    private final boolean hasError;
    private final boolean hasWarning;
    private final String errorMessage;
    private final String warningMessage;
    private String message;
    private HashMap<String, String> infoParams = new HashMap();
    private Map<String, Object> data = new HashMap<String, Object>();
    private Map<String, String> dataType = new HashMap<String, String>();

    public MethodResult() {
        this.hasError = false;
        this.hasWarning = false;
        this.errorMessage = "";
        this.message = "";
        this.warningMessage = "";
    }

    public MethodResult(String errorMessage) {
        this.hasError = true;
        this.hasWarning = false;
        this.errorMessage = errorMessage;
        this.message = "";
        this.warningMessage = "";
    }

    public MethodResult(String errorMessage, String warnnigMessage) {
        this.hasError = false;
        this.hasWarning = true;
        this.errorMessage = errorMessage;
        this.message = "";
        this.warningMessage = warnnigMessage;
    }

    public MethodResult(boolean hasError, String errorMessage) {
        this.hasError = hasError;
        this.errorMessage = errorMessage;
        this.message = "";
        this.hasWarning = false;
        this.warningMessage = "";
    }

    public HashMap<String, String> getInfoParams() {
        return this.infoParams;
    }

    public void setInfoParams(HashMap<String, String> infoParams) {
        this.infoParams = infoParams;
    }

    public void setInfo(HashMap<String, String> info) {
        this.infoParams.putAll(info);
    }

    public String getDataType(String key) {
        return this.dataType.get(key);
    }

    public void setData(String key, ArrayCache value) {
        this.data.put(key, value);
        this.dataType.put(key, value.getType().toString());
    }

    public ArrayCache getDataArrayCache(String key) {
        return (ArrayCache)this.data.get(key);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public String getDataString(String key) {
        return (String)this.data.get(key);
    }

    public String[] getDataNames() {
        return this.data.keySet().toArray(new String[this.data.keySet().size()]);
    }

    public Portfolio getPortfolio(String key) {
        return (Portfolio)this.data.get(key);
    }

    public void setPortfolio(String key, Portfolio portfolio) {
        this.dataType.put(key, "PORTFOLIO");
        this.data.put(key, portfolio);
    }

    public long[] getLongArray(String key) {
        try {
            return ((ArrayCache)this.data.get(key)).getLongArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getLastLong(String key) {
        long[] x = new long[]{-1L};
        try {
            x = ((ArrayCache)this.data.get(key)).getLongArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return x[x.length - 1];
    }

    public double getLastDouble(String key) {
        double[] x = new double[]{0.0};
        try {
            x = ((ArrayCache)this.data.get(key)).getDoubleArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return x[x.length - 1];
    }

    public double[] getLastDoubleArray(String key) {
        Object x = new double[][]{{0.0}};
        try {
            x = ((ArrayCache)this.data.get(key)).getDoubleMatrix();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return x[((double[][])x).length - 1];
    }

    public double[] getDoubleArray(String key) {
        try {
            return ((ArrayCache)this.data.get(key)).getDoubleArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double[][] getDoubleMatrix(String key) {
        try {
            return ((ArrayCache)this.data.get(key)).getDoubleMatrix();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getInfoParam(String key) {
        if (!this.infoParams.containsKey(key)) {
            return String.format("No such parameters: %s", key);
        }
        return this.infoParams.get(key);
    }

    public String getParamName() {
        String params = "";
        for (String e : this.infoParams.keySet()) {
            params = String.valueOf(params) + " " + e;
        }
        return params;
    }

    public int getValueInt(String key) {
        if (!this.infoParams.containsKey(key)) {
            return 0;
        }
        return Integer.parseInt(this.infoParams.get(key));
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void makeLastResultOnlyDouble(String key) {
        try {
            ArrayCache newResult = new ArrayCache(ArrayCacheType.NULL);
            double[] resultArray = null;
            try {
                resultArray = this.getDoubleArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resultArray.length == 0) {
                return;
            }
            newResult = new ArrayCache(new double[]{resultArray[resultArray.length - 1]});
            newResult.closeOut();
            this.setData(key, newResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyLong(String key) {
        try {
            ArrayCache newTime = new ArrayCache(ArrayCacheType.NULL);
            long[] timeArray = null;
            try {
                timeArray = this.getLongArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newTime = new ArrayCache(new long[]{timeArray[timeArray.length - 1]});
            newTime.closeOut();
            this.setData(key, newTime);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyDouble(String key, int batchSize) {
        try {
            ArrayCache newResult = new ArrayCache(ArrayCacheType.NULL);
            double[] resultArray = null;
            try {
                resultArray = this.getDoubleArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            double[] valuesLast = new double[batchSize];
            if (resultArray.length == 0) {
                return;
            }
            int i = 0;
            while (i < batchSize) {
                valuesLast[i] = resultArray[resultArray.length - batchSize + i];
                ++i;
            }
            newResult = new ArrayCache(valuesLast);
            this.setData(key, newResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyLong(String key, int batchSize) {
        try {
            ArrayCache newTime = new ArrayCache(ArrayCacheType.NULL);
            long[] timeArray = null;
            timeArray = this.getLongArray(key);
            newTime = new ArrayCache(new long[]{timeArray[timeArray.length - 1]});
            this.setData(key, newTime);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getStringArray(String key) {
        return (String[])this.data.get(key);
    }

    public void setStringArray(String key, String[] stringArray) {
        this.dataType.put(key, "STRING_VECTOR");
        this.data.put(key, stringArray);
    }
}

