/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.loader;

import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.template.ComposedScalar;
import org.openfast.template.Field;
import org.openfast.template.Scalar;
import org.openfast.template.loader.AbstractFieldParser;
import org.openfast.template.loader.ParsingContext;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;
import org.openfast.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComposedDecimalParser
extends AbstractFieldParser {
    public ComposedDecimalParser() {
        super("decimal");
    }

    public boolean canParse(Element element, ParsingContext context) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String nodeName = children.item(i).getNodeName();
            if (nodeName.equals("mantissa") || nodeName.equals("exponent")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Field parse(Element fieldNode, boolean optional, ParsingContext context) {
        NodeList fieldChildren = fieldNode.getChildNodes();
        Node mantissaNode = null;
        Node exponentNode = null;
        int i = 0;
        while (i < fieldChildren.getLength()) {
            if ("mantissa".equals(fieldChildren.item(i).getNodeName())) {
                mantissaNode = fieldChildren.item(i);
            } else if ("exponent".equals(fieldChildren.item(i).getNodeName())) {
                exponentNode = fieldChildren.item(i);
            }
            ++i;
        }
        return this.createComposedDecimal(fieldNode, context.getName(), optional, mantissaNode, exponentNode, context);
    }

    private Field createComposedDecimal(Element fieldNode, QName name, boolean optional, Node mantissaNode, Node exponentNode, ParsingContext context) {
        Element operatorElement;
        String mantissaOperator = "none";
        String exponentOperator = "none";
        ScalarValue mantissaDefaultValue = ScalarValue.UNDEFINED;
        ScalarValue exponentDefaultValue = ScalarValue.UNDEFINED;
        QName mantissaKey = null;
        QName exponentKey = null;
        String mantissaDictionary = context.getDictionary();
        String exponentDictionary = context.getDictionary();
        String mantissaNamespace = context.getNamespace();
        String exponentNamespace = context.getNamespace();
        if (mantissaNode != null && mantissaNode.hasChildNodes() && (operatorElement = ComposedDecimalParser.getElement((Element)mantissaNode, 1)) != null) {
            mantissaOperator = operatorElement.getNodeName();
            if (operatorElement.hasAttribute("value")) {
                mantissaDefaultValue = Type.I64.getValue(operatorElement.getAttribute("value"));
            }
            if (operatorElement.hasAttribute("ns")) {
                mantissaNamespace = operatorElement.getAttribute("ns");
            }
            if (operatorElement.hasAttribute("key")) {
                mantissaKey = new QName(operatorElement.getAttribute("key"), mantissaNamespace);
            }
            if (operatorElement.hasAttribute("dictionary")) {
                mantissaDictionary = operatorElement.getAttribute("dictionary");
            }
        }
        if (exponentNode != null && exponentNode.hasChildNodes() && (operatorElement = ComposedDecimalParser.getElement((Element)exponentNode, 1)) != null) {
            exponentOperator = operatorElement.getNodeName();
            if (operatorElement.hasAttribute("value")) {
                exponentDefaultValue = Type.I32.getValue(operatorElement.getAttribute("value"));
            }
            if (operatorElement.hasAttribute("ns")) {
                exponentNamespace = operatorElement.getAttribute("ns");
            }
            if (operatorElement.hasAttribute("key")) {
                exponentKey = new QName(operatorElement.getAttribute("key"), exponentNamespace);
            }
            if (operatorElement.hasAttribute("dictionary")) {
                exponentDictionary = operatorElement.getAttribute("dictionary");
            }
        }
        ComposedScalar scalar = Util.composedDecimal(name, Operator.getOperator(exponentOperator), exponentDefaultValue, Operator.getOperator(mantissaOperator), mantissaDefaultValue, optional);
        Scalar exponent = scalar.getFields()[0];
        exponent.setDictionary(exponentDictionary);
        if (exponentKey != null) {
            exponent.setKey(exponentKey);
        }
        Scalar mantissa = scalar.getFields()[1];
        mantissa.setDictionary(mantissaDictionary);
        if (mantissaKey != null) {
            mantissa.setKey(mantissaKey);
        }
        if (fieldNode.hasAttribute("id")) {
            scalar.setId(fieldNode.getAttribute("id"));
        }
        return scalar;
    }
}

