/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.xml;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.openfast.Context;
import org.openfast.GroupValue;
import org.openfast.Message;
import org.openfast.SequenceValue;
import org.openfast.codec.FastDecoder;
import org.openfast.extensions.MapFieldParser;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Sequence;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class FastToXmlConverter {
    private final TemplateRegistry templateRegistry;
    private final MessageTemplate elementTemplate;
    private final int nodeNameIdx;
    private final int attributesIdx;
    private final int childrenIdx;
    private final int valueIdx;
    private final int attributeNameIdx;
    private final int attributeValueIdx;

    public FastToXmlConverter() {
        XMLMessageTemplateLoader xmlTemplateLoader = new XMLMessageTemplateLoader();
        xmlTemplateLoader.setLoadTemplateIdFromAuxId(true);
        xmlTemplateLoader.addFieldParser(new MapFieldParser());
        xmlTemplateLoader.load(this.getClass().getResourceAsStream("xmlOverFastTemplates.xml"));
        this.templateRegistry = xmlTemplateLoader.getTemplateRegistry();
        this.elementTemplate = this.templateRegistry.get("element");
        this.nodeNameIdx = this.elementTemplate.getFieldIndex("name");
        this.attributesIdx = this.elementTemplate.getFieldIndex("attributes");
        Sequence attributesSequence = this.elementTemplate.getSequence("attributes");
        this.attributeNameIdx = attributesSequence.getGroup().getFieldIndex("name");
        this.attributeValueIdx = attributesSequence.getGroup().getFieldIndex("value");
        this.childrenIdx = this.elementTemplate.getFieldIndex("children");
        this.valueIdx = this.elementTemplate.getFieldIndex("value");
    }

    public void convert(InputStream in, OutputStream out) {
        try {
            HierarchicalStreamWriter writer = new XppDriver().createWriter(out);
            Context context = new Context();
            context.setTemplateRegistry(this.templateRegistry);
            FastDecoder decoder = new FastDecoder(context, in);
            Message message = decoder.readMessage();
            this.writeXml(writer, message);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeXml(HierarchicalStreamWriter writer, GroupValue message) {
        Iterator iter;
        writer.startNode(message.getString(this.nodeNameIdx));
        if (message.isDefined(this.attributesIdx)) {
            SequenceValue attributes = message.getSequence(this.attributesIdx);
            iter = attributes.iterator();
            while (iter.hasNext()) {
                GroupValue attr = (GroupValue)iter.next();
                writer.addAttribute(attr.getString(this.attributeNameIdx), attr.getString(this.attributeValueIdx));
            }
        }
        if (message.isDefined(this.valueIdx)) {
            writer.setValue(message.getString(this.valueIdx));
        }
        if (message.isDefined(this.childrenIdx)) {
            SequenceValue children = message.getSequence(this.childrenIdx);
            iter = children.iterator();
            while (iter.hasNext()) {
                GroupValue child = (GroupValue)iter.next();
                this.writeXml(writer, child.getGroup(0));
            }
        }
        writer.endNode();
    }
}

