/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.math.BigDecimal;
import java.util.Iterator;
import org.openfast.BitVector;
import org.openfast.BitVectorValue;
import org.openfast.ByteVectorValue;
import org.openfast.DecimalValue;
import org.openfast.FieldValue;
import org.openfast.IntegerValue;
import org.openfast.ScalarValue;
import org.openfast.SequenceValue;
import org.openfast.StringValue;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.LongValue;
import org.openfast.template.Scalar;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;
import org.openfast.util.ArrayIterator;

public class GroupValue
implements FieldValue {
    private static final long serialVersionUID = 1L;
    protected final FieldValue[] values;
    private final Group group;

    public GroupValue(Group group, FieldValue[] values) {
        if (group == null) {
            throw new NullPointerException();
        }
        this.group = group;
        this.values = values;
        int i = 0;
        while (i < group.getFieldCount()) {
            Scalar scalar;
            if (group.getField(i) instanceof Scalar && (scalar = (Scalar)group.getField(i)).getOperator().equals((Object)Operator.CONSTANT) && !scalar.isOptional()) {
                values[i] = scalar.getDefaultValue();
            }
            ++i;
        }
    }

    public GroupValue(Group group) {
        this(group, new FieldValue[group.getFieldCount()]);
    }

    public Iterator iterator() {
        return new ArrayIterator(this.values);
    }

    public int getInt(int fieldIndex) {
        return this.getScalar(fieldIndex).toInt();
    }

    public int getInt(String fieldName) {
        if (!this.group.hasField(fieldName) && this.group.hasIntrospectiveField(fieldName)) {
            Scalar scalar = this.group.getIntrospectiveField(fieldName);
            if (scalar.getType().equals(Type.UNICODE) || scalar.getType().equals(Type.STRING) || scalar.getType().equals(Type.ASCII)) {
                return this.getString(scalar.getName()).length();
            }
            if (scalar.getType().equals(Type.BYTE_VECTOR)) {
                return this.getBytes(scalar.getName()).length;
            }
        }
        return this.getScalar(fieldName).toInt();
    }

    public boolean getBool(String fieldName) {
        if (!this.isDefined(fieldName)) {
            return false;
        }
        return this.getScalar(fieldName).toInt() != 0;
    }

    public long getLong(int fieldIndex) {
        return this.getScalar(fieldIndex).toLong();
    }

    public long getLong(String fieldName) {
        return this.getScalar(fieldName).toLong();
    }

    public byte getByte(int fieldIndex) {
        return this.getScalar(fieldIndex).toByte();
    }

    public byte getByte(String fieldName) {
        return this.getScalar(fieldName).toByte();
    }

    public short getShort(int fieldIndex) {
        return this.getScalar(fieldIndex).toShort();
    }

    public short getShort(String fieldName) {
        return this.getScalar(fieldName).toShort();
    }

    public String getString(int index) {
        return this.getValue(index).toString();
    }

    public String getString(String fieldName) {
        FieldValue value = this.getValue(fieldName);
        return value == null ? null : value.toString();
    }

    public double getDouble(int fieldIndex) {
        return this.getScalar(fieldIndex).toDouble();
    }

    public double getDouble(String fieldName) {
        return this.getScalar(fieldName).toDouble();
    }

    public BigDecimal getBigDecimal(int fieldIndex) {
        return this.getScalar(fieldIndex).toBigDecimal();
    }

    public BigDecimal getBigDecimal(String fieldName) {
        return this.getScalar(fieldName).toBigDecimal();
    }

    public byte[] getBytes(int fieldIndex) {
        return this.getScalar(fieldIndex).getBytes();
    }

    public byte[] getBytes(String fieldName) {
        return this.getScalar(fieldName).getBytes();
    }

    public SequenceValue getSequence(int fieldIndex) {
        return (SequenceValue)this.getValue(fieldIndex);
    }

    public SequenceValue getSequence(String fieldName) {
        return (SequenceValue)this.getValue(fieldName);
    }

    public ScalarValue getScalar(int fieldIndex) {
        return (ScalarValue)this.getValue(fieldIndex);
    }

    public ScalarValue getScalar(String fieldName) {
        return (ScalarValue)this.getValue(fieldName);
    }

    public GroupValue getGroup(int fieldIndex) {
        return (GroupValue)this.getValue(fieldIndex);
    }

    public GroupValue getGroup(String fieldName) {
        return (GroupValue)this.getValue(fieldName);
    }

    public FieldValue getValue(int fieldIndex) {
        return this.values[fieldIndex];
    }

    public FieldValue getValue(String fieldName) {
        if (!this.group.hasField(fieldName)) {
            return null;
        }
        return this.values[this.group.getFieldIndex(fieldName)];
    }

    public Group getGroup() {
        return this.group;
    }

    public void setString(Field field, String value) {
        if (field == null) {
            throw new IllegalArgumentException("Field must not be null [value=" + value + "]");
        }
        this.setFieldValue(field, field.createValue(value));
    }

    public void setFieldValue(Field field, FieldValue value) {
        this.setFieldValue(this.group.getFieldIndex(field), value);
    }

    public void setFieldValue(int fieldIndex, FieldValue value) {
        this.values[fieldIndex] = value;
    }

    public void setBitVector(int fieldIndex, BitVector vector) {
        this.values[fieldIndex] = new BitVectorValue(vector);
    }

    public void setByteVector(int fieldIndex, byte[] bytes) {
        this.values[fieldIndex] = new ByteVectorValue(bytes);
    }

    public void setByteVector(String fieldName, byte[] bytes) {
        this.setFieldValue(fieldName, (FieldValue)new ByteVectorValue(bytes));
    }

    public void setDecimal(int fieldIndex, double value) {
        this.values[fieldIndex] = new DecimalValue(value);
    }

    public void setDecimal(String fieldName, double value) {
        this.setFieldValue(fieldName, (FieldValue)new DecimalValue(value));
    }

    public void setDecimal(int fieldIndex, BigDecimal value) {
        this.values[fieldIndex] = new DecimalValue(value);
    }

    public void setDecimal(String fieldName, BigDecimal value) {
        this.setFieldValue(fieldName, (FieldValue)new DecimalValue(value));
    }

    public void setInteger(String fieldName, int value) {
        this.setFieldValue(fieldName, (FieldValue)new IntegerValue(value));
    }

    public void setInteger(int fieldIndex, int value) {
        this.values[fieldIndex] = new IntegerValue(value);
    }

    public void setBool(String fieldName, boolean value) {
        this.setFieldValue(fieldName, (FieldValue)new IntegerValue(value ? 1 : 0));
    }

    public void setLong(String fieldName, long value) {
        this.setFieldValue(fieldName, (FieldValue)new LongValue(value));
    }

    public void setLong(int fieldIndex, long value) {
        this.values[fieldIndex] = new LongValue(value);
    }

    public void setString(int fieldIndex, String value) {
        this.values[fieldIndex] = this.group.getField(fieldIndex).createValue(value);
    }

    public void setString(String fieldName, String value) {
        this.setFieldValue(fieldName, this.group.getField(fieldName).createValue(value));
    }

    public void setFieldValue(int fieldIndex, Object value) {
        ScalarValue fieldValue = ScalarValue.NULL;
        if (value instanceof String) {
            fieldValue = new StringValue(String.valueOf(value));
        } else if (value instanceof Integer) {
            fieldValue = new IntegerValue((Integer)value);
        } else if (value instanceof Long) {
            fieldValue = new LongValue((Long)value);
        } else if (value instanceof Boolean) {
            fieldValue = new IntegerValue((Boolean)value != false ? 1 : 0);
        } else if (value instanceof Double) {
            fieldValue = new DecimalValue((Double)value);
        }
        this.setFieldValue(fieldIndex, (FieldValue)fieldValue);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof GroupValue)) {
            return false;
        }
        return this.equals((GroupValue)other);
    }

    private boolean equals(GroupValue other) {
        if (this.values.length != other.values.length) {
            return false;
        }
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i] == null ? other.values[i] != null : !this.values[i].equals(other.values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.group).append(" -> {");
        int i = 0;
        while (i < this.values.length) {
            builder.append(this.values[i]).append(", ");
            ++i;
        }
        if (this.values.length > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("}");
        return builder.toString();
    }

    public void setFieldValue(String fieldName, FieldValue value) {
        if (!this.group.hasField(fieldName)) {
            throw new IllegalArgumentException("The field " + fieldName + " does not exist in group " + this.group);
        }
        int index = this.group.getFieldIndex(fieldName);
        this.setFieldValue(index, value);
    }

    public int getFieldCount() {
        return this.values.length;
    }

    public void setFieldValue(String fieldName, String value) {
        this.setFieldValue(fieldName, this.group.getField(fieldName).createValue(value));
    }

    public boolean isDefined(int fieldIndex) {
        return fieldIndex < this.values.length && fieldIndex >= 0 && this.values[fieldIndex] != null;
    }

    public boolean isDefined(String fieldName) {
        return this.getValue(fieldName) != null;
    }

    public FieldValue copy() {
        FieldValue[] copies = new FieldValue[this.values.length];
        int i = 0;
        while (i < copies.length) {
            copies[i] = this.values[i].copy();
            ++i;
        }
        return new GroupValue(this.group, this.values);
    }
}

