% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf7.R
\name{mf7}
\alias{mf7}
\title{The full Fisher Information Matrix (FIM) for one individual Calculating one model switch at a time, good for large matrices.}
\usage{
mf7(model_switch, xt_ind, x, a, bpop, d, sigma, docc, poped.db)
}
\arguments{
\item{model_switch}{A vector that is the same size as xt, specifying which model each sample belongs to.}

\item{x}{A vector for the discrete design variables.}

\item{a}{A vector of covariates.}

\item{bpop}{The fixed effects parameter values.  Supplied as a vector.}

\item{d}{A between subject variability matrix (OMEGA in NONMEM).}

\item{sigma}{A residual unexplained variability matrix (SIGMA in NONMEM).}

\item{docc}{A between occasion variability matrix.}

\item{poped.db}{A PopED database.}
}
\value{
As a list:
\item{ret}{The FIM for one individual}
\item{poped.db}{A PopED database}
}
\description{
Compute the full FIM for one individual given specific model(s), parameters, design and methods. 
This computation calculates the FIM for each model switch separately.  Correlations between the models parameters are assumed to be zero.
}
\seealso{
Other FIM: \code{\link{LinMatrixH}},
  \code{\link{LinMatrixLH}}, \code{\link{LinMatrixL_occ}},
  \code{\link{calc_ofv_and_fim}},
  \code{\link{ed_laplace_ofv}}, \code{\link{ed_mftot}},
  \code{\link{efficiency}},
  \code{\link{evaluate.e.ofv.fim}},
  \code{\link{evaluate.fim}}, \code{\link{gradf_eps}},
  \code{\link{mf3}}, \code{\link{mftot}},
  \code{\link{ofv_criterion}}, \code{\link{ofv_fim}}
}
\concept{FIM}
\keyword{internal}
