% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/create_design_space.R
\name{create_design_space}
\alias{create_design_space}
\title{Create design variables and a design space for a full decription of an optimization problem.}
\usage{
create_design_space(design, maxni = NULL, minni = NULL, maxtotni = NULL,
  mintotni = NULL, maxgroupsize = NULL, mingroupsize = NULL,
  maxtotgroupsize = NULL, mintotgroupsize = NULL, maxxt = NULL,
  minxt = NULL, maxa = NULL, mina = NULL, x_space = NULL,
  use_grouped_xt = FALSE, grouped_xt = NULL, use_grouped_a = FALSE,
  grouped_a = NULL, use_grouped_x = FALSE, grouped_x = NULL,
  our_zero = NULL)
}
\arguments{
\item{design}{The output from a call to \code{\link{create_design}}.}

\item{maxni}{Vector defining the maximum number of samples per group.}

\item{minni}{Vector defining the minimum number of samples per group.}

\item{maxtotni}{Number defining the maximum number of samples allowed in the experiment.}

\item{mintotni}{Number defining the minimum number of samples allowed in the experiment.}

\item{maxgroupsize}{Vector defining the maximum size of the different groups (maximum number of individuals in each group)}

\item{mingroupsize}{Vector defining the minimum size of the different groups (minimum num individuals in each group)}

\item{maxtotgroupsize}{The total maximal groupsize over all groups}

\item{mintotgroupsize}{The total minimal groupsize over all groups}

\item{maxxt}{Matrix or single value defining the maximum value for each xt sample.  If a single value is
supplied then all xt values are given the same maximum value.}

\item{minxt}{Matrix or single value defining the minimum value for each xt sample.  If a single value is
supplied then all xt values are given the same minimum value}

\item{maxa}{Vector defining the maximum value for each covariate. IF a single value is supplied then
all a values are given the same maximum value}

\item{mina}{Vector defining the minimum value for each covariate. IF a single value is supplied then
all a values are given the same minimum value}

\item{x_space}{Cell array \code{\link{cell}} defining the discrete variables for each x value.}

\item{use_grouped_xt}{Group sampling times between groups so that each group has the same values (\code{TRUE} or \code{FALSE}).}

\item{grouped_xt}{Matrix defining the grouping of sample points. Matching integers mean that the points are matched.
Allows for finer control than \code{use_grouped_xt}}

\item{use_grouped_a}{Group continuous design variables between groups so that each group has the same values (\code{TRUE} or \code{FALSE}).}

\item{grouped_a}{Matrix defining the grouping of continuous design variables. Matching integers mean that the values are matched.
Allows for finer control than \code{use_grouped_a}.}

\item{use_grouped_x}{Group discrete design variables between groups so that each group has the same values (\code{TRUE} or \code{FALSE}).}

\item{grouped_x}{Matrix defining the grouping of discrete design variables. Matching integers mean that the values are matched.
Allows for finer control than \code{use_grouped_x}.}

\item{our_zero}{Value to interpret as zero in design.}
}
\description{
\code{create_design_space} takes an initial design and arguments for a design space and
creates a design and design space for design optimization.
Checks the sizes of supplied design space variables and
changes them to sizes that  make sense if there are inconsistencies.
Function arguments can use shorthand notation (single values, vectors, lists of vectors and
list of list) or matricies.
Returns a list of matricies compatible with PopED.
}
\details{
If a value (or a vector or a list of values) is supplied that correponds to only one group and the design has
multiple groups then all groups will have the same value(s). If a matrix is expected then a list of lists can be supplied
instead, each list corresponding to a group.
}
\examples{
library(PopED)

design_1 <- create_design(xt=list(c(1,2,3,4,5),
                                  c(1,2,3,4)),
                          groupsize=c(50,20),
                          a=list(c(WT=70,DOSE=1000),
                                 c(DOSE=1000,WT=35)))

ds_1 <- create_design_space(design_1)

ds_2 <- create_design_space(design_1,maxni=10,maxxt=10,minxt=0)

ds_3 <- create_design_space(design_1,maxni=10,mingroupsize=20,maxxt=10,minxt=0)

ds_4 <- create_design_space(design_1,maxa=c(100,2000))

ds_5 <- create_design_space(design_1,mina=c(10,20))

design_2 <- create_design(xt=list(c(1,2,3,4,5),
                                  c(1,2,3,4)),
                          groupsize=c(50,20),
                          a=list(c(WT=70,DOSE=1000),
                                 c(WT=35,DOSE=1000)),
                          x=list(c(SEX=1,DOSE_discrete=100),
                                 c(SEX=2,DOSE_discrete=200)))

ds_6 <- create_design_space(design_2) 

ds_7 <- create_design_space(design_2,
                            x_space=list(SEX=c(1,2),
                                         DOSE_discrete=seq(100,400,by=20)))

ds_8 <- create_design_space(design_2,
                            x_space=list(SEX=c(1,2),
                                         DOSE_discrete=seq(100,400,by=20)),
                            grouped_xt=c(1,2,3,4,5))

ds_9 <- create_design_space(design_2,
                            x_space=list(SEX=c(1,2),
                                         DOSE_discrete=seq(100,400,by=20)),
                            use_grouped_xt=TRUE)

design_3 <- create_design(xt=list(c(1,2,3,4,5),
                                  c(1,2,3,4)),
                          groupsize=c(50,20),
                          a=list(c(WT=35,DOSE=1000)),
                          x=list(c(SEX=1,DOSE_discrete=100)))

ds_10 <- create_design_space(design_3,
                             x_space=list(SEX=c(1,2),DOSE_discrete=seq(100,400,by=20)),
                             use_grouped_a=TRUE)

ds_11 <- create_design_space(design_2,
                             x_space=list(SEX=c(1,2),DOSE_discrete=seq(100,400,by=20)),
                             grouped_a=list(c(1,2),c(3,2)))

ds_12 <- create_design_space(design_3,
                             x_space=list(SEX=c(1,2),DOSE_discrete=seq(100,400,by=20)),
                             use_grouped_x=TRUE)

ds_13 <- create_design_space(design_3,
                             x_space=list(SEX=c(1,2),DOSE_discrete=seq(100,400,by=20)),
                             grouped_x=list(c(1,2),c(3,2)))
}
\seealso{
Other poped_input: \code{\link{convert_variables}};
  \code{\link{create.poped.database}};
  \code{\link{create_design}};
  \code{\link{downsizing_general_design}};
  \code{\link{poped.choose}}
}

