% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangle.R
\name{Triangle}
\alias{Triangle}
\title{R6 class representing a triangle}
\description{
A triangle has three vertices. They are named A, B, C.
}
\examples{
# incircle and excircles
A <- c(0,0); B <- c(1,2); C <- c(3.5,1)
t <- Triangle$new(A, B, C)
incircle <- t$incircle()
excircles <- t$excircles()
JA <- excircles$A$center
JB <- excircles$B$center
JC <- excircles$C$center
JAJBJC <- Triangle$new(JA, JB, JC)
A_JA <- Line$new(A, JA, FALSE, FALSE)
B_JB <- Line$new(B, JB, FALSE, FALSE)
C_JC <- Line$new(C, JC, FALSE, FALSE)
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type = "n", asp = 1, xlim = c(0,6), ylim = c(-4,4),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(incircle, border = "orange")
draw(excircles$A); draw(excircles$B); draw(excircles$C)
draw(JAJBJC, col = "blue")
draw(A_JA, col = "green")
draw(B_JB, col = "green")
draw(C_JC, col = "green")
par(opar)


## ------------------------------------------------
## Method `Triangle$new`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(1,0), c(1,1))
t
t$C
t$C <- c(2,2)
t

## ------------------------------------------------
## Method `Triangle$print`
## ------------------------------------------------

Triangle$new(c(0,0), c(1,0), c(1,1))

## ------------------------------------------------
## Method `Triangle$NagelTriangle`
## ------------------------------------------------

t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
lineAB <- Line$new(t$A, t$B)
lineAC <- Line$new(t$A, t$C)
lineBC <- Line$new(t$B, t$C)
NagelTriangle <- t$NagelTriangle(NagelPoint = TRUE)
NagelPoint <- attr(NagelTriangle, "Nagel point")
excircles <- t$excircles()
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type="n", asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(lineAB); draw(lineAC); draw(lineBC)
draw(excircles$A, border = "orange")
draw(excircles$B, border = "orange")
draw(excircles$C, border = "orange")
draw(NagelTriangle, lwd = 2, col = "red")
draw(Line$new(t$A, NagelTriangle$A, FALSE, FALSE), col = "blue")
draw(Line$new(t$B, NagelTriangle$B, FALSE, FALSE), col = "blue")
draw(Line$new(t$C, NagelTriangle$C, FALSE, FALSE), col = "blue")
points(rbind(NagelPoint), pch = 19)
par(opar)

## ------------------------------------------------
## Method `Triangle$MalfattiCircles`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
Mcircles <- t$MalfattiCircles(TRUE)
plot(0, 0, type="n", asp = 1, xlim = c(0,2.5), ylim = c(0,2.5),
     xlab = NA, ylab = NA)
grid()
draw(t, col = "blue", lwd = 2)
invisible(lapply(Mcircles, draw, col = "green", border = "red"))
invisible(lapply(attr(Mcircles, "tangencyPoints"), function(P){
  points(P[1], P[2], pch = 19)
}))

## ------------------------------------------------
## Method `Triangle$trilinearToPoint`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,1), c(5,7))
incircle <- t$incircle()
t$trilinearToPoint(1, 1, 1)
incircle$center
}
\seealso{
\code{\link{TriangleThreeLines}} to define a triangle by three lines.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{A}}{get or set the vertex \code{A}}

\item{\code{B}}{get or set the vertex \code{B}}

\item{\code{C}}{get or set the vertex \code{C}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Triangle$new()}}
\item \href{#method-print}{\code{Triangle$print()}}
\item \href{#method-flatness}{\code{Triangle$flatness()}}
\item \href{#method-a}{\code{Triangle$a()}}
\item \href{#method-b}{\code{Triangle$b()}}
\item \href{#method-c}{\code{Triangle$c()}}
\item \href{#method-edges}{\code{Triangle$edges()}}
\item \href{#method-contains}{\code{Triangle$contains()}}
\item \href{#method-isAcute}{\code{Triangle$isAcute()}}
\item \href{#method-angleA}{\code{Triangle$angleA()}}
\item \href{#method-angleB}{\code{Triangle$angleB()}}
\item \href{#method-angleC}{\code{Triangle$angleC()}}
\item \href{#method-angles}{\code{Triangle$angles()}}
\item \href{#method-X175}{\code{Triangle$X175()}}
\item \href{#method-VeldkampIsoperimetricPoint}{\code{Triangle$VeldkampIsoperimetricPoint()}}
\item \href{#method-centroid}{\code{Triangle$centroid()}}
\item \href{#method-orthocenter}{\code{Triangle$orthocenter()}}
\item \href{#method-area}{\code{Triangle$area()}}
\item \href{#method-incircle}{\code{Triangle$incircle()}}
\item \href{#method-excircles}{\code{Triangle$excircles()}}
\item \href{#method-orthicTriangle}{\code{Triangle$orthicTriangle()}}
\item \href{#method-incentralTriangle}{\code{Triangle$incentralTriangle()}}
\item \href{#method-NagelTriangle}{\code{Triangle$NagelTriangle()}}
\item \href{#method-NagelPoint}{\code{Triangle$NagelPoint()}}
\item \href{#method-GergonneTriangle}{\code{Triangle$GergonneTriangle()}}
\item \href{#method-GergonnePoint}{\code{Triangle$GergonnePoint()}}
\item \href{#method-tangentialTriangle}{\code{Triangle$tangentialTriangle()}}
\item \href{#method-circumcircle}{\code{Triangle$circumcircle()}}
\item \href{#method-MalfattiCircles}{\code{Triangle$MalfattiCircles()}}
\item \href{#method-AjimaMalfatti1}{\code{Triangle$AjimaMalfatti1()}}
\item \href{#method-AjimaMalfatti2}{\code{Triangle$AjimaMalfatti2()}}
\item \href{#method-equalDetourPoint}{\code{Triangle$equalDetourPoint()}}
\item \href{#method-trilinearToPoint}{\code{Triangle$trilinearToPoint()}}
\item \href{#method-rotate}{\code{Triangle$rotate()}}
\item \href{#method-translate}{\code{Triangle$translate()}}
\item \href{#method-randomPoints}{\code{Triangle$randomPoints()}}
\item \href{#method-clone}{\code{Triangle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{Triangle} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$new(A, B, C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{A, B, C}}{vertices}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Triangle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(1,0), c(1,1))
t
t$C
t$C <- c(2,2)
t
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Show instance of a triangle object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Triangle$new(c(0,0), c(1,0), c(1,1))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-flatness"></a>}}
\subsection{Method \code{flatness()}}{
Flatness of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$flatness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number between 0 and 1. A triangle is flat when its flatness is 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-a"></a>}}
\subsection{Method \code{a()}}{
Length of the side \code{BC}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$a()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-b"></a>}}
\subsection{Method \code{b()}}{
Length of the side \code{AC}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$b()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c"></a>}}
\subsection{Method \code{c()}}{
Length of the side \code{AB}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$c()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-edges"></a>}}
\subsection{Method \code{edges()}}{
The lengths of the sides of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$edges()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named numeric vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-contains"></a>}}
\subsection{Method \code{contains()}}{
Determines whether a point lies inside the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$contains(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isAcute"></a>}}
\subsection{Method \code{isAcute()}}{
Determines whether the reference triangle is acute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$isAcute()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
`TRUE` if the triangle is acute (or right), `FALSE` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angleA"></a>}}
\subsection{Method \code{angleA()}}{
Angle at the vertex A.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleA()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex A in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angleB"></a>}}
\subsection{Method \code{angleB()}}{
Angle at the vertex B.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleB()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex B in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angleC"></a>}}
\subsection{Method \code{angleC()}}{
Angle at the vertex C.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleC()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex C in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angles"></a>}}
\subsection{Method \code{angles()}}{
The three angles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named vector containing the values of the angles in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-X175"></a>}}
\subsection{Method \code{X175()}}{
The X(175) triangle center.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$X175()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VeldkampIsoperimetricPoint"></a>}}
\subsection{Method \code{VeldkampIsoperimetricPoint()}}{
Isoperimetric point in the sense of Veldkamp.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$VeldkampIsoperimetricPoint()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The isoperimetric point in the sense of Veldkamp, if it exists.
Otherwise, returns `NULL`.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-centroid"></a>}}
\subsection{Method \code{centroid()}}{
Centroid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$centroid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-orthocenter"></a>}}
\subsection{Method \code{orthocenter()}}{
Orthocenter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$orthocenter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-area"></a>}}
\subsection{Method \code{area()}}{
Area of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$area()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-incircle"></a>}}
\subsection{Method \code{incircle()}}{
Incircle of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$incircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-excircles"></a>}}
\subsection{Method \code{excircles()}}{
Excircles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$excircles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the three excircles, \code{Circle} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-orthicTriangle"></a>}}
\subsection{Method \code{orthicTriangle()}}{
Orthic triangle. Its vertices are the feet of the altitudes
of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$orthicTriangle()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-incentralTriangle"></a>}}
\subsection{Method \code{incentralTriangle()}}{
Incentral triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$incentralTriangle()}\if{html}{\out{</div>}}
}

\subsection{Details}{
It is the triangle whose vertices are the intersections of the
reference triangle's angle bisectors with the respective opposite sides.
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NagelTriangle"></a>}}
\subsection{Method \code{NagelTriangle()}}{
Nagel triangle (or extouch triangle) of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$NagelTriangle(NagelPoint = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{NagelPoint}}{logical, whether to return the Nagel point as attribute}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
lineAB <- Line$new(t$A, t$B)
lineAC <- Line$new(t$A, t$C)
lineBC <- Line$new(t$B, t$C)
NagelTriangle <- t$NagelTriangle(NagelPoint = TRUE)
NagelPoint <- attr(NagelTriangle, "Nagel point")
excircles <- t$excircles()
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type="n", asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(lineAB); draw(lineAC); draw(lineBC)
draw(excircles$A, border = "orange")
draw(excircles$B, border = "orange")
draw(excircles$C, border = "orange")
draw(NagelTriangle, lwd = 2, col = "red")
draw(Line$new(t$A, NagelTriangle$A, FALSE, FALSE), col = "blue")
draw(Line$new(t$B, NagelTriangle$B, FALSE, FALSE), col = "blue")
draw(Line$new(t$C, NagelTriangle$C, FALSE, FALSE), col = "blue")
points(rbind(NagelPoint), pch = 19)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NagelPoint"></a>}}
\subsection{Method \code{NagelPoint()}}{
Nagel point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$NagelPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GergonneTriangle"></a>}}
\subsection{Method \code{GergonneTriangle()}}{
Gergonne triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$GergonneTriangle(GergonnePoint = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{GergonnePoint}}{logical, whether to return the Gergonne point as an attribute}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The Gergonne triangle is also known as the
\emph{intouch triangle} or the \emph{contact triangle}.
This is the triangle made of the three tangency points of the incircle.
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GergonnePoint"></a>}}
\subsection{Method \code{GergonnePoint()}}{
Gergonne point of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$GergonnePoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tangentialTriangle"></a>}}
\subsection{Method \code{tangentialTriangle()}}{
Tangential triangle of the reference triangle.
This is the triangle formed by the lines tangent to the circumcircle of
the reference triangle at its vertices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$tangentialTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-circumcircle"></a>}}
\subsection{Method \code{circumcircle()}}{
Circumcircle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$circumcircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MalfattiCircles"></a>}}
\subsection{Method \code{MalfattiCircles()}}{
Malfatti circles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$MalfattiCircles(tangencyPoints = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangencyPoints}}{logical, whether to retourn the tangency points of
the Malfatti circles as an attribute.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the three Malfatti circles, \code{Circle} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
Mcircles <- t$MalfattiCircles(TRUE)
plot(0, 0, type="n", asp = 1, xlim = c(0,2.5), ylim = c(0,2.5),
     xlab = NA, ylab = NA)
grid()
draw(t, col = "blue", lwd = 2)
invisible(lapply(Mcircles, draw, col = "green", border = "red"))
invisible(lapply(attr(Mcircles, "tangencyPoints"), function(P){
  points(P[1], P[2], pch = 19)
}))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AjimaMalfatti1"></a>}}
\subsection{Method \code{AjimaMalfatti1()}}{
First Ajima-Malfatti point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$AjimaMalfatti1()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AjimaMalfatti2"></a>}}
\subsection{Method \code{AjimaMalfatti2()}}{
Second Ajima-Malfatti point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$AjimaMalfatti2()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-equalDetourPoint"></a>}}
\subsection{Method \code{equalDetourPoint()}}{
Equal detour point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$equalDetourPoint(detour = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{detour}}{logical, whether to return the detour as an attribute.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Also known as the X(176) triangle center.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trilinearToPoint"></a>}}
\subsection{Method \code{trilinearToPoint()}}{
Point given by trilinear coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$trilinearToPoint(x, y, z)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x, y, z}}{trilinear coordinates}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The point with trilinear coordinates \code{x:y:z} with respect to
the reference triangle.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,1), c(5,7))
incircle <- t$incircle()
t$trilinearToPoint(1, 1, 1)
incircle$center
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rotate"></a>}}
\subsection{Method \code{rotate()}}{
Rotate the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$rotate(alpha, O, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{angle of rotation}

\item{\code{O}}{center of rotation}

\item{\code{degrees}}{logical, whether \code{alpha} is given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-translate"></a>}}
\subsection{Method \code{translate()}}{
Translate the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$translate(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{the vector of translation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-randomPoints"></a>}}
\subsection{Method \code{randomPoints()}}{
Random points on or in the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$randomPoints(n, where = "in")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{an integer, the desired number of points}

\item{\code{where}}{\code{"in"} to generate inside the triangle,
\code{"on"} to generate on the triangle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The generated points in a two columns matrix with \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
