% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{init.simulate.OU}
\alias{init.simulate.OU}
\title{Initialize state and expectation matrices}
\usage{
init.simulate.OU(phy, p, root.state, optimal.value, simulate_random, ...)
}
\arguments{
\item{root.state}{(list): state of the root, with:
random : random state (TRUE) or deterministic state (FALSE)
value.root : if deterministic, value of the character at the root
exp.root : if random, expectation of the character at the root
var.root : if random, variance of the character at the root (pxp matrix)}

\item{phy:}{Input tree.}

\item{p:}{dimension of the trait simulated}
}
\value{
paramSimu: array p x Nnode x 3, filled with NAs.
Slice paramSimu[, ntaxa + 1, ] (array p x 3) is initialized with simulated states, root
expectations, and optimal values for all the traits.
}
\description{
Function used in \code{\link{simulate}} for OU initialization.
}
\keyword{internal}
