% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{equivalent_shifts_edges}
\alias{equivalent_shifts_edges}
\title{Find all the equivalent shift edges allocations.}
\usage{
equivalent_shifts_edges(phylo, shifts_edges,
  part.list = enumerate_tips_under_edges(phylo))
}
\arguments{
\item{phylo}{a phylogenetic tree, class \code{\link[ape]{phylo}}.}

\item{shifts_edges}{a vector of shifts positions on the edges of the tree.}

\item{part.list}{(optional) list of partition of the tree, result of function
\code{\link{enumerate_tips_under_edges}}.}
}
\value{
a matrix with as many columns as equivalent allocation, each column
 representing a possible parsimonious allocation of shifts on the tree.
}
\description{
\code{equivalent_shifts_edges} uses function \code{\link{enumerate_parsimony}}
to find all the shifts positions that are equivalent to a given one.
}
\details{
This function is uses functions \code{\link{enumerate_parsimony}} for the
actual computation of equivalent regimes,
\code{\link{clusters_from_shifts}} for the clustering of the tips induced
by the original set of shifts given, and
\code{\link{allocate_shifts_from_regimes}} to convert back a parametrization
in term of regimes to a parametrization in term of shifts.
}
\seealso{
\code{\link{equivalent_shifts}}, \code{\link{enumerate_parsimony}}
}
\keyword{internal}
