% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ManipStringSet.R
\name{ManipStringSet}
\alias{ManipStringSet}
\title{Manipulate String Set}
\usage{
ManipStringSet(DNAStringSet)
}
\arguments{
\item{DNAStringSet}{A DNA string set object.}
}
\value{
A DNA string set (that is ready for analysis)
}
\description{
Orient and align DNA sequences in a DNA string set object.
}
\examples{
# generate and manipulate a DNA string set object using the taxon 'Antheraea polyphemus'
specdf_Anth <- querySpecData("Antheraea polyphemus")[1:10,]

DNABin_Anth <- genDNABin(specdf_Anth)

DNAStringset_Anth <- genDNAStringSet(DNABin_Anth)

DNAStringSet_Anth_manipulated <- ManipStringSet(DNAStringset_Anth)
}
