% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator_functions.R, R/PH.R, R/DPH.R,
%   R/MPH.R, R/MDPH.R
\name{generator_functions}
\alias{generator_functions}
\alias{PH}
\alias{DPH}
\alias{MPH}
\alias{MDPH}
\title{The phase-type distribution}
\usage{
PH(subint_mat = NULL, init_probs = NULL)

DPH(subint_mat = NULL, init_probs = NULL)

MPH(subint_mat = NULL, init_probs = NULL,
    reward_mat = NULL)

MDPH(subint_mat = NULL, init_probs = NULL,
     reward_mat = NULL)
}
\arguments{
\item{subint_mat}{a square matrix containing the transition rates or
probabilities between transient states for continuous or discrete
phase-type respectively.
If the phase-type is continuous, the sub-intensity matrix diagonal should
only contain negative values and the row sums should be non-positive.
If the phase-type is discrete, the sub-intensity matrix should only contain
values between 0 and 1.}

\item{init_probs}{a vector, a one-row matrix or \code{NULL} which gives the
probabilities to start in each state. If \code{init_probs} is \code{NULL},
the probability to start on the first state will be 1 and 0 otherwise.}

\item{reward_mat}{a matrix \code{NULL}(default) where each row is a reward
vector, and each column corresponds to a state. It should have the same
number of columns as the length of the initial probabilities.}
}
\value{
A phase-type object of class \code{cont_phase_type} for \code{PH}, \code{disc_phase_type} for \code{DPH},
\code{mult_cont_phase_type} for \code{MPH}, and \code{mult_disc_phase_type} for \code{MDPH}.
All these classes inherit from \code{list}.
}
\description{
Generator functions for the S3 classes \code{cont_phase_type}, \code{disc_phase_type},
\code{mult_cont_phase_type}, \code{mult_disc_phase_type}, which represent the
different phase-type distributions.
}
\details{
\code{PH}, \code{DPH}, \code{MPH} and \code{MDPH} are the generator functions
for the four types of phase-type distribution
classes, this is, the continuous univariate, the discrete univariate, the continuous multivariate
and the discrete multivariate respectively.
The class is generated by supplying a sub-intensity matrix and an optional
initial probability vector plus a reward matrix in the case of multivariate
phase-type.
If the initial probabilities are not specified, then the initial probability
will be \code{init_probs = c(1, 0, 0, ...)} with the same length as the
number of transient states.
}
\examples{

##===========================##
## For continuous univariate ##
##===========================##

subintensity_matrix <- matrix(c(-1.5, 1.5, 0,
                                 0,  -1,   1,
                                 0,   0,  -0.5),
                              ncol = 3,
                              byrow = TRUE)
PH(subintensity_matrix)

#---

subintensity_matrix <- matrix(c(-1.5, 1.5, 0,
                                 0,  -1,   1,
                                 0,   0,  -0.5),
                              ncol = 3,
                              byrow = TRUE)
initial_probabilities <- c(0.9, 0.1, 0)
PH(subintensity_matrix, initial_probabilities)


##=========================##
## For discrete univariate ##
##=========================##

subintensity_matrix <- matrix(c(0.4, 0.24, 0.12,
                                0,   0.4,  0.2,
                                0,   0,    0.5),
                              ncol = 3,
                              byrow = TRUE)
DPH(subintensity_matrix)

#---

subintensity_matrix <- matrix(c(0.4, 0.24, 0.12,
                                0,   0.4,  0.2,
                                0,   0,    0.5),
                              ncol = 3,
                              byrow = TRUE)
initial_probabilities <- c(0.9, 0.1, 0)
DPH(subintensity_matrix, initial_probabilities)



##=============================##
## For continuous multivariate ##
##=============================##

subintensity_matrix <- matrix(c(-3,  2,  0,
                                 0, -2,  1,
                                 0,  0, -1),
                              nrow = 3,
                              byrow = TRUE)
reward_matrix = matrix(sample(seq(0, 10, 0.1), 6), nrow = 3, ncol = 2)
initial_probabilities = c(1, 0, 0)
MPH(subintensity_matrix,
    initial_probabilities,
    reward_matrix)


##===========================##
## For discrete multivariate ##
##===========================##

subintensity_matrix <- matrix(c(0.4, 0.24, 0.12,
                                0,   0.4,  0.2,
                                0,   0,    0.5),
                              ncol = 3,
                              byrow = TRUE)
reward_matrix <- matrix(sample(seq(0, 10), 6), nrow = 3, ncol = 2)
initial_probabilities = c(1, 0, 0)
MDPH(subintensity_matrix,
     initial_probabilities,
     reward_mat = reward_matrix)

}
