% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppraisalRatio.R
\name{AppraisalRatio}
\alias{AppraisalRatio}
\title{Appraisal ratio of the return distribution}
\usage{
AppraisalRatio(
  Ra,
  Rb,
  Rf = 0,
  method = c("appraisal", "modified", "alternative"),
  ...
)
}
\arguments{
\item{Ra}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{Rb}{return vector of the benchmark asset}

\item{Rf}{risk free rate, in same period as your returns}

\item{method}{is one of "appraisal" to calculate appraisal ratio, "modified" to
calculate modified Jensen's alpha or "alternative" to calculate alternative
Jensen's alpha.}

\item{\dots}{any other passthru parameters}
}
\description{
Appraisal ratio is the Jensen's alpha adjusted for specific risk. The numerator
is divided by specific risk instead of total risk.
}
\details{
Modified Jensen's alpha is Jensen's alpha divided by beta.

Alternative Jensen's alpha is Jensen's alpha divided by systematic risk.

\deqn{Appraisal ratio = \frac{\alpha}{\sigma_{\epsilon}}}{Appraisal ratio = Jensen's alpha / specific risk}

\deqn{Modified Jensen's alpha = \frac{\alpha}{\beta}}{Modified Jensen's alpha = Jensen's alpha / beta}

\deqn{Alternative Jensen's alpha = \frac{\alpha}{\sigma_S}}{Alternative Jensen's alpha = Jensen's alpha / systematic risk}

where \eqn{alpha} is the Jensen's alpha, \eqn{\sigma_{epsilon}} is the specific risk,
\eqn{\sigma_S} is the systematic risk.
}
\examples{

data(portfolio_bacon)
print(AppraisalRatio(portfolio_bacon[,1], portfolio_bacon[,2], method="appraisal")) #expected -0.430
print(AppraisalRatio(portfolio_bacon[,1], portfolio_bacon[,2], method="modified")) 
print(AppraisalRatio(portfolio_bacon[,1], portfolio_bacon[,2], method="alternative"))

data(managers)
print(AppraisalRatio(managers['1996',1], managers['1996',8]))
print(AppraisalRatio(managers['1996',1:5], managers['1996',8]))

}
\references{
Carl Bacon, \emph{Practical portfolio performance measurement 
and attribution}, second edition 2008 p.77
}
\author{
Matthieu Lestel
}
