% Generated by roxygen2 (4.0.2): do not edit by hand
\name{table.ProbOutPerformance}
\alias{table.ProbOutPerformance}
\title{Outperformance Report of Asset vs Benchmark}
\usage{
table.ProbOutPerformance(R, Rb, period_lengths = c(1, 3, 6, 9, 12, 18, 36))
}
\arguments{
\item{R}{an xts, timeSeries or zoo object of asset returns}

\item{Rb}{an xts, timeSeries or zoo object of the benchmark returns}

\item{period_lengths}{a vector of periods the user wants to evaluate this
over i.e. c(1,3,6,9,12,18,36)}
}
\description{
Table of Outperformance Reporting vs Benchmark
}
\details{
Returns a table that contains the counts and probabilities
of outperformance relative to benchmark for the various period_lengths

Tool for robustness analysis of an asset or strategy, can be used to
give the probability an investor investing at any point in time will
outperform the benchmark over a given horizon. Calculates Count of
trailing periods where a fund outperformed its benchmark and calculates
the proportion of those periods, this is commonly used in marketing as
the probability of outperformance on a N period basis.

Returns a table that contains the counts and probabilities
of outperformance relative to benchmark for the various period_lengths
}
\examples{
data(edhec)

table.ProbOutPerformance(edhec[,1],edhec[,2])
title(main='Table of Convertible Arbitrage vs Benchmark')
}
\author{
Kyle Balkissoon
}

