% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addDateOfBirth}
\alias{addDateOfBirth}
\title{Add a column with the individual birth date}
\usage{
addDateOfBirth(
  x,
  dateOfBirthName = "date_of_birth",
  missingDay = 1,
  missingMonth = 1,
  imposeDay = FALSE,
  imposeMonth = FALSE,
  name = NULL
)
}
\arguments{
\item{x}{Table in the cdm that contains 'person_id' or 'subject_id'.}

\item{dateOfBirthName}{Name of the column to be added with the date of birth.}

\item{missingDay}{Day of the individuals with no or imposed day of birth.}

\item{missingMonth}{Month of the individuals with no or imposed month of
birth.}

\item{imposeDay}{Whether to impose day of birth.}

\item{imposeMonth}{Whether to impose month of birth.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
The function returns the table x with an extra column that contains
the date of birth.
}
\description{
Add a column with the individual birth date
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- mockPatientProfiles()
cdm$cohort1 \%>\%
  addDateOfBirth()
mockDisconnect(cdm = cdm)
}
}
