% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addConceptIntersect.R
\name{addConceptIntersect}
\alias{addConceptIntersect}
\title{It creates columns to indicate overlap information between a table and a
concept}
\usage{
addConceptIntersect(
  x,
  conceptSet,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  window = list(c(0, Inf)),
  targetStartDate = "cohort_start_date",
  targetEndDate = "cohort_end_date",
  order = "first",
  flag = TRUE,
  count = TRUE,
  date = TRUE,
  days = TRUE,
  nameStyle = "{value}_{concept_name}_{window_name}"
)
}
\arguments{
\item{x}{Table with individuals in the cdm}

\item{conceptSet}{Concept set list.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a date column of x}

\item{window}{window to consider events in.}

\item{targetStartDate}{date of reference in cohort table, either for start
(in overlap) or on its own (for incidence)}

\item{targetEndDate}{date of reference in cohort table, either for end
(overlap) or NULL (if incidence)}

\item{order}{which record is considered in case of multiple records}

\item{flag}{TRUE or FALSE. If TRUE, flag will calculated for this
intersection}

\item{count}{TRUE or FALSE. If TRUE, the number of counts will be calculated
for this intersection}

\item{date}{TRUE or FALSE. If TRUE, date will be calculated for this
intersection}

\item{days}{TRUE or FALSE. If TRUE, time difference in days will be
calculated for this intersection}

\item{nameStyle}{naming of the added column or columns, should include
required parameters}
}
\value{
table with added columns with overlap information
}
\description{
It creates columns to indicate overlap information between a table and a
concept
}
\examples{
\donttest{
library(PatientProfiles)
library(CodelistGenerator)

cdm <- mockPatientProfiles()
# result <- cdm$cohort1 \%>\%
#   addConceptIntersect(
#     conceptSet = getDrugIngredientCodes(cdm, "acetaminophen")
#  ) \%>\%
#   dplyr::collect()
}

}
