% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollectiveModelMethods.R
\name{Simulate_Losses}
\alias{Simulate_Losses}
\title{Simulate Losses with a Collective Model}
\usage{
Simulate_Losses(CollectiveModel, nyears = 1)
}
\arguments{
\item{CollectiveModel}{A collective model object. Currently only \code{PPP_Models} are handled.}

\item{nyears}{Integer. Number of simulated years.}
}
\value{
A matrix where row k contains the simulated losses of the kth simulated year.
}
\description{
Simulates losses with a collective model
}
\examples{
PPPM <- PiecewisePareto_Match_Layer_Losses(c(1000, 2000, 3000), c(2000, 1000, 500),
                                           truncation = 10000, truncation_type = "wd")
PPPM
Simulate_Losses(PPPM, 100)

}
