% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{GenPareto_ML_Estimator_Alpha}
\alias{GenPareto_ML_Estimator_Alpha}
\title{Maximum Likelihood Estimation of the Pareto Alphas of a Generalized Pareto Distribution}
\usage{
GenPareto_ML_Estimator_Alpha(
  losses,
  t,
  truncation = NULL,
  tol = 1e-07,
  max_iterations = 1000,
  alpha_min = 0.01,
  alpha_max = 100
)
}
\arguments{
\item{losses}{Numeric vector. Losses that are used for the ML estimation.}

\item{t}{Numeric or numeric vector. Threshold of the generalized Pareto distribution. Alternatively, \code{t} can be a vector of same length as \code{losses}. In this case \code{t[i]} is the reporting threshold of \code{losses[i]}.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the generalized Pareto distribution is truncated at \code{truncation}.}

\item{tol}{Numeric. Desired accuracy  (only relevant in the truncated case).}

\item{max_iterations}{Numeric. Maximum number of iteration in the case \code{truncation < Inf}  (only relevant in the truncated case).}

\item{alpha_min}{Numeric. Lower bound for the estimated alphas.}

\item{alpha_max}{Numeric. Upper bound for the estimated alphas.}
}
\value{
Maximum likelihood estimator for the parameters \code{alpha_ini} and \code{alpha_tail} of a generalized Pareto distribution with threshold \code{t} given the observations \code{losses}
}
\description{
Calculates the maximum likelihood estimators of the parameters alpha_ini and alpha_tail of a generalized Pareto distribution
}
\examples{
losses <- rGenPareto(1000, 1000, 2,3)
GenPareto_ML_Estimator_Alpha(losses, 1000)
losses <- rGenPareto(1000, 1000, 2, 1, truncation = 10000)
GenPareto_ML_Estimator_Alpha(losses, 1000)
GenPareto_ML_Estimator_Alpha(losses, 1000, truncation = 10000)

t <- rPareto(10000, 100, 2)
alpha_ini <- 1
alpha_tail <- 3
losses <- rGenPareto(10000, t, alpha_ini, alpha_tail)
GenPareto_ML_Estimator_Alpha(losses, t)
losses <- rGenPareto(10000, t, alpha_ini, alpha_tail, truncation = 2 * max(t))
GenPareto_ML_Estimator_Alpha(losses, t, truncation = 2 * max(t))
}
