% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pno.R
\name{pno}
\alias{pno}
\title{Non-Linear Pseudo-nth-Order Adsorption Kinetic Model}
\usage{
pno(t, qt, qe)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}

\item{qe}{the numerical value for the amount adsorbed at equilibrium. If this parameter is not defined, it will be estimated.}
}
\value{
the non-linear regression and the parameter estimation for the Pseudo-nth-Order Model
}
\description{
The Pseudo-nth Order Adsorption Kinetic Model is an empirical rate equation known to describe the kinetic analysis of neither order 1 nor 2 kinetic parameters. It will have a significant effect on the calculation of the rate constants as the rate constant is dependent on the order of reaction (Tseng, Wu, Wu, and Juang, 2014).
}
\examples{
\donttest{
t <- c(0,15,30,45,60,75,90,105,120)
qt <- c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qe <- 4.8
pno(t,qt,qe)}
}
\references{
Ozer, A. (2007) <doi:10.1016/j.jhazmat.2006.07.040> Removal of Pb(II) ions from aqueous solutions by sulphuric acid-treated wheat bran. Journal of Hazardous Materials, 141(3), 753-761.

Tseng, R. L., Wu, P. H., Wu, F. C., &; Juang, R. S. (2014) <doi:10.1016/j.cej.2013.10.013> A convenient method to determine kinetic parameters of adsorption processes by nonlinear regression of pseudo-nth-order equation. Chemical Engineering Journal, 237, 153-161.
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
