% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_target}
\alias{plot_target}
\title{Plot the surface of the target function for the nonlinear least square estimation.}
\usage{
plot_target(obj, im = 1, iq = NULL, par = NULL, basedon = c(1, 2),
  from, to, length.out = 40)
}
\arguments{
\item{obj}{an object of the class PSTR returned from some functions in the package.}

\item{im}{specifies the number of switches in the transtion function. The default value is 1.}

\item{iq}{a column number (in \code{mQ}) or variable name specifying the transition variable to use.}

\item{par}{a vector of the values of the parameters. NULL by default, then it will be made automatically.}

\item{basedon}{an integer vector of length 2 specify which two parameters to use to build the grid.}

\item{from}{a vector of length 2 of the starting (minimal) values of the parameters.}

\item{to}{a vector of length 2 of the end (maximal) values of the parameters.}

\item{length.out}{a 2-dim vector or scalar of desired length (number of points) for the parameters. 40 by default.}
}
\value{
A plottable object from the \code{plotly} package.
}
\description{
This function plots the surface of the target function for the nonlinear least square estimation.
It is useful for finding the suitable initial value for the estimation.
}
\details{
The funciton uses the \code{plotly} package to plot the 3-D surface of the target function for the nonlinear least square estimation.

The function takes the PSTR object as one of the inputs. The user needs to give the number of switches \code{im}, and the transition variable \code{iq},
such that the target function values can be computed.

The number of parameters to estimate in the nonlinear least square estimation is \code{1+im}, that is, one smoothness parameter and the \code{im} switching locations.
However, the 3-D plot is based on only two changing parameters with the others (if more than two parameters) constant. Thus, the user needs to input a vector \code{par},
which gives the values of the other parameters. Note that \code{par} should still be of length \code{1+im} with the order \eqn{\delta} (always use delta in this function),
\eqn{c_1}, ..., \eqn{c_m}.

The user should give the vector \code{basedon} of length two, that shows which two parameters will be used to build the grid.
\code{basedon} gives the positions of the two parameters in \code{par}. Thus, the values in the positions \code{basedon} in \code{par} will not be used.

\code{from}, \code{to} and \code{length.out} serve to build the grid for the two parameters.
These arguments must be of length two for the two parameters, respectively.
See the \code{seq} function for the details.
}
\examples{
\donttest{
pstr = NewPSTR(Hansen99, dep='inva', indep=4:20, indep_k=c('vala','debta','cfa','sales'),
    tvars=c('vala'), iT=14) # create a new PSTR object

# build the grid based on the first two parameters
ret = plot_target(obj=pstr,iq=1,basedon=c(1,2),from=c(log(1),6),
  to=c(log(18),10),length.out=c(40,40))
}

}
\seealso{
Functions which return an object of the class PSTR and can be input into this function

\code{\link{NewPSTR}}, \code{\link{LinTest}}, \code{\link{WCB_LinTest}}, \code{\link{EstPSTR}}, \code{\link{EvalTest}}, \code{\link{WCB_TVTest}} and \code{\link{WCB_HETest}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{utils}
