% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSTR.R
\name{NewPSTR}
\alias{NewPSTR}
\title{Create an object of the class PSTR.}
\usage{
NewPSTR(data, dep, indep, indep_k = NULL, tvars, im = 1, iT)
}
\arguments{
\item{data}{a tibble of data. The number of rows of \code{data} must be the sample size \code{iT} times individuals number N.}

\item{dep}{column number or name of the dependent variable. Note that this must be specified.}

\item{indep}{a vector of column numbers of names of the independent variables. Note that this must be specified.}

\item{indep_k}{a vector of column numbers of names of the independent variables in the nonlinear part. If \code{indep_k} is not given (\code{= NULL}), the nonlinear part will be the same as the linear part.}

\item{tvars}{a vector of column numbers or names of the potential transition variables to be tested.}

\item{im}{maximal number of switches in the transition function used in the linearity evaluation tests, by default \code{im=1}.}

\item{iT}{sample size.}
}
\value{
An object of the class PSTR for later usage.

The object is a list containing the following components:
\item{iT}{the time length of the panel}
\item{iN}{the number of individuals}
\item{vY}{the vector of the dependent variable}
\item{mX}{the matrix of the explanatory variables in the linear part}
\item{mK}{the matrix of the explanatory variables in the nonlinear part}
\item{mQ}{the matrix of the potential transition variables}
\item{im}{the maximal number of switches used in the linearity test}
}
\description{
Create an object of the S3 class PSTR for later usage. This function should be run prior to the other functions in the package. It will return an object which you will use as an input for the other functions. It builds up the basic settings for the Panel Smooth Transition Regression (PSTR) Modelling.
}
\details{
Potential transition variables in \code{tvars} will be tested one by one in, for example, \code{LinTest} function.

There is no need to specify the number of individuals,  as it will be obtained automatically inside the function given the number of rows and the sample size \code{iT}.

\code{NA}s in \code{data} are removed automatically inside the function.
}
\examples{
pstr = NewPSTR(Hansen99, dep='inva', indep=4:20, indep_k=c('vala','debta','cfa','sales'),
    tvars=c('vala','debta'), iT=14)

pstr

print(pstr,"summary")

}
\seealso{
\code{\link{LinTest}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{initialization}
