% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_reprod.R
\name{pop_reprod}
\alias{pop_reprod}
\title{Seed production and crop yield}
\usage{
pop_reprod(start, area, kw, pen_co, kc, dc, crop_inr, SSmax, yield = FALSE)
}
\arguments{
\item{start}{column names of parental cohorts. \code{character vector}.}

\item{area}{number of area units. \code{positive numeric}.}

\item{kw}{dimensionless weed competition parameter. \code{numeric}.}

\item{pen_co}{penalty values for different weed cohorts. \code{numeric vector}, each element in [0,1].}

\item{kc}{dimensionless crop competition parameter. \code{numeric}.}

\item{dc}{crop sowing density, seeds per unit area. \code{numeric}.}

\item{crop_inr}{position of the crop in the crop rotation. \code{positive integer} \eqn{\le} length of the crop rotation.}

\item{SSmax}{maximum of weed seed production per unit area. \code{positive integer}.}

\item{yield}{\code{logical}, whether the percentage of yield gained should be calculated.}
}
\description{
Calculates the produced seeds and optionally the proportion of crop yield that is realized relative to weed free yield (Renton at al. 2011).
}
\details{
The number of produced seeds is calculated for 1m^2 by the formula:
\cr
\deqn{over\_all  = 1 + kc*dc[crop\_inr] + sum(kw*dw*pen\_co)} 
\deqn{producedseeds  = round(sum((SSmax[crop\_inr] * kw * dw * pen_co)/over\_all),digits=0)}
\deqn{propyield = (1 + kc*dc[crop\_inr])/over\_all}
\cr
The weed density \code{dw} is calculated for each squaremeter derived from the current simulation run (\code{start}). The used parameters values apply to wheat and ryegrass (Pannell et al. 2004, cited in Renton et al. 2011).
}
\examples{
struc_preparation2(Rmx=10, af=c(0.01,0.8), epis=0, dom=1)
#Distribute 10000 individuals of the starting population across the genotypes provided by tmp. 
#The two gene loci have initial frequencies of 0.01 and 0.8.
gen_freq(af=c(0.01,0.8), n_seeds=10000, max_vec_length=1e+07)
pop_reprod("initialSB",  area=100, kw=0.5, pen_co=1, kc=0.05, dc=100, 
                         crop_inr="wheat", SSmax=3000, yield=TRUE)
rm(producedseeds, dfgenotype, mf, xprobab, propyield)
}
\references{
Renton, M.; Diggle, A.; Manalil, S. & Powles, S. (2011): Does cutting herbicide rates threaten the sustainability of weed management in cropping systems? Journal of Theoretical Biology, 283, 14-27.
Pannell, D. J.; Stewart, V.; Bennett, A.; Monjardino, M.; Schmidt, C. & Powles, S. B. (2004): RIM: a bioeconomic model for integrated weed management of Lolium rigidum in Western Australia Agricultural Systems, 79, 305-325
}
\seealso{
\code{\link{pop_reprod}} \code{\link{pop_step}}
}
