% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcs.R
\name{mcs}
\alias{mcs}
\title{Monte Carlo Simulation.}
\usage{
mcs(num_sims, task_dists, cor_mat = NULL)
}
\arguments{
\item{num_sims}{The number of simulations.}

\item{task_dists}{A list of lists describing each task distribution.}

\item{cor_mat}{The correlation matrix for the tasks.}
}
\value{
The function returns a list of the total mean, variance, standard deviation,
and percentiles for the project.
}
\description{
Monte Carlo Simulation.
}
\examples{
num_sims <- 10000
task_dists <- list(
  list(type = "normal", mean = 10, sd = 2),  # Task A: Normal distribution
  list(type = "triangular", a = 5, b = 10, c = 15),  # Task B: Triangular distribution
  list(type = "uniform", min = 8, max = 12)  # Task C: Uniform distribution
)
cor_mat <- matrix(c(
  1, 0.5, 0.3,
  0.5, 1, 0.4,
  0.3, 0.4, 1
), nrow = 3, byrow = TRUE)
results <- mcs(num_sims, task_dists, cor_mat)
cat("Mean Total Duration:", results$total_mean, "\n")
cat("Variance of Total Variance:", results$total_variance, "\n")
cat("Standard Deviation of Total Duration:", results$total_sd, "\n")
cat("5th Percentile:", results$percentiles[1], "\n")
cat("Median (50th Percentile):", results$percentiles[2], "\n")
cat("95th Percentile:", results$percentiles[3], "\n")
hist(results$total_distribution, breaks = 50, main = "Distribution of Total Project Duration",
  xlab = "Total Duration", col = "skyblue", border = "white")
}
