% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{residuals.PLreg}
\alias{residuals.PLreg}
\title{Residuals Method for PLreg Objects}
\usage{
\method{residuals}{PLreg}(object, type = c("quantile", "deviance", "standardized"), ...)
}
\arguments{
\item{object}{fitted model object of class "\code{PLreg}".}

\item{type}{character specifying the type of residuals to be used.}

\item{...}{currently not used.}
}
\value{
\code{residuals} method for object of class "\code{PLreg}" returns a vector
with the residuals of the type specified in the \code{type} argument.
}
\description{
The function provides three types of residuals for power logit regression models:
quantile, deviance and standardized.
}
\details{
The \emph{quantile residuals} is based on Dunn and Smyth (1996) idea. The
residuals are well-defined for all the distributions in the power logit class and
have, approximately, a standard normal distribution in large samples if the model is
correctly specified. \cr \cr
The \emph{deviance residuals} are based on the log-likelihood contributions
of each observation in the sample. The distribution of this residual is unknown
(both exact and asymptotic),  except for the power logit normal model, which is,
approximately, standard normal.\cr \cr
The \emph{standardized residuals} are a standardized form of the ordinary
residual. These residuals take into account the diagonal elements of the \eqn{H}
matrix, being useful for detecting leverage observations. The distribution
of the standardized residuals is unknown.
}
\examples{
data("PeruVotes")
fitPL <- PLreg(votes ~ HDI | HDI, data = PeruVotes,
              family = "TF", zeta = 5)

res_quantile = residuals(fitPL, type = "quantile")
res_standardized = residuals(fitPL, type = "standardized")

plot(res_standardized, pch = "+", ylim = c(-6, 6))
abline(h = -3, lty = 2)
abline(h = 3, lty = 2)

qqnorm(res_quantile)
qqline(res_quantile)
}
\references{
Queiroz, F. F. and Ferrari, S. L. P. (2022). Power logit regression
for modeling bounded data. \emph{arXiv}:2202.01697. \cr \cr
Dunn, P. K. and Smyth, G. K. (1996) Randomized quantile residuals.
\emph{Journal of Computational and Graphical Statistics}, 5:236-244.
}
\seealso{
\code{\link{PLreg}}, \code{\link{plot.PLreg}}, \code{\link{envelope}}, \code{\link{influence}}
}
