% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.pre.r
\name{plsim.pre}
\alias{plsim.pre}
\title{Predict according to the Estimated Parameters}
\usage{
plsim.pre(x_test = NULL, z_test, model)
}
\arguments{
\item{x_test}{input matrix (linear covariates of test set).}

\item{z_test}{input matrix (nonlinear covariates of test set).}

\item{model}{fitted partially linear single-index model, which could be obtained by 
\link{plsim.MAVE}, or \link{plsim.est}, or \link{plsim.vs.soft}.}
}
\value{
\item{y_hat}{prediction.}
}
\description{
Predict Y based on new observations.
}
\examples{

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

x = matrix(1,n,1)
x_test = matrix(1,n,1)

z = matrix(runif(n*2),n,2)
z_test = matrix(runif(n*2),n,2)

y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)
y_test = 4*((z_test\%*\%alpha-1/sqrt(2))^2) + x_test\%*\%beta + sigma*matrix(rnorm(n),n,1)


# Obtain parameters in PLSiM using Profile Least Squares Estimator
fit_plsimest = plsim.est(x,z,y)

preds_plsimest = plsim.pre(x_test,z_test,fit_plsimest)

# Print the MSE of the Profile Least Squares Estimator method
print( sum( (preds_plsimest-y_test)^2)/nrow(y_test) )

# Obtain parameters in PLSiM using Penalized Profile Least Squares Estimator
fit_plsim = plsim.vs.soft(x,z,y,lambda = 0.01)

preds_plsim = plsim.pre(x_test,z_test,fit_plsim)

# Print the MSE of the Penalized Profile Least Squares Estimator method
print( sum( (preds_plsim-y_test)^2)/nrow(y_test) )

}
