% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.ini.r
\name{plsim.ini}
\alias{plsim.ini}
\alias{plsim.ini.formula}
\alias{plsim.ini.default}
\title{Initialize coefficients}
\usage{
plsim.ini(\dots)

\method{plsim.ini}{formula}(formula, data, \dots)

\method{plsim.ini}{default}(xdat, zdat, ydat, Method="MAVE_ini", verbose = TRUE, \dots)
}
\arguments{
\item{\dots}{additional arguments.}

\item{formula}{a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{xdat}{input matrix (linear covariates). The model reduces to a single index model when \code{x} is NULL.}

\item{zdat}{input matrix (nonlinear covariates). \code{z} should not be NULL.}

\item{ydat}{input vector (response variable).}

\item{Method}{string, optional (default="MAVE_ini").}

\item{verbose}{bool, default: TRUE. Enable verbose output.}
}
\value{
\item{zeta_i}{initial coefficients. \code{zeta_i[1:ncol(z)]} is the initial coefficient vector 
\eqn{\boldmath{\alpha}_0}, and \code{zeta_i[(ncol(z)+1):(ncol(z)+ncol(x))]} is the initial 
coefficient vector \eqn{\boldmath{\beta}_0}.}
}
\description{
Xia \emph{et al.}'s MAVE method is used to obtain initialized 
coefficients \eqn{\alpha_0} and \eqn{\beta_0} for PLSiM 
\deqn{Y = \eta(Z^T\alpha) + X^T\beta + \epsilon}.
}
\examples{

# EXAMPLE 1 (INTERFACE=FORMULA)
# To obtain initial values by using MAVE methods for partially
# linear single-index model.

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

# Case1: Matrix Input
x = matrix(1,n,1)
z = matrix(runif(n*2),n,2)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

zeta_i = plsim.ini(y~x|z)

# Case 2: Vector Input
x = rep(1,n)
z1 = runif(n)
z2 = runif(n) 
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

zeta_i = plsim.ini(y~x|z1+z2)


# EXAMPLE 2 (INTERFACE=DATA FRAME)
# To obtain initial values by using MAVE methods for partially
# linear single-index model.

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")
beta = matrix(4,1,1)

x = rep(1,n)
z1 = runif(n)
z2 = runif(n) 
X = data.frame(x)
Z = data.frame(z1,z2)

x = data.matrix(X)
z = data.matrix(Z)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

zeta_i = plsim.ini(xdat=X, zdat=Z, ydat=y)

}
\references{
Y. Xia, W. Härdle. \emph{Semi-parametric estimation of partially linear single-index models}.
Journal of Multivariate Analysis, 2006, 97(5): 1162-1184.
}
