% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.MAVE.r
\name{plsim.MAVE}
\alias{plsim.MAVE}
\alias{plsim.MAVE.formula}
\alias{plsim.MAVE.default}
\title{Minimum Average Variance Estimation}
\usage{
plsim.MAVE(\dots)

\method{plsim.MAVE}{formula}(formula, data, \dots)

\method{plsim.MAVE}{default}(xdat=NULL, zdat, ydat, h=NULL, zeta_i=NULL, maxStep=100,
tol=1e-8, iniMethods="MAVE_ini", ParmaSelMethod="SimpleValidation", TestRatio=0.1, 
K = 3, seed=0, verbose=TRUE, \dots)
}
\arguments{
\item{\dots}{additional arguments.}

\item{formula}{a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{xdat}{input matrix (linear covariates). The model reduces to a single index model when \code{x} is NULL.}

\item{zdat}{input matrix (nonlinear covariates). \code{z} should not be NULL.}

\item{ydat}{input vector (response variable).}

\item{h}{a numerical value or a vector for bandwidth. If \code{h} is NULL, a default 
vector c(0.01,0.02,0.05,0.1,0.5) will be given. 
\link{plsim.bw} is employed to select the optimal bandwidth when \code{h} is a vector or NULL.}

\item{zeta_i}{initial coefficients, optional (default: NULL). It could be obtained by the function \code{\link{plsim.ini}}.
\code{zeta_i[1:ncol(z)]} is the initial coefficient vector \eqn{\boldmath{\alpha}_0},
and \code{zeta_i[(ncol(z)+1):(ncol(z)+ncol(x))]} is the initial coefficient vector \eqn{\boldmath{\beta}_0}.}

\item{maxStep}{the maximum iterations, default: 100.}

\item{tol}{convergence tolerance, default: 1e-8.}

\item{iniMethods}{string, optional (default: "SimpleValidation").}

\item{ParmaSelMethod}{the parameter for the function \link{plsim.bw}.}

\item{TestRatio}{the parameter for the function \link{plsim.bw}.}

\item{K}{the parameter for the function \link{plsim.bw}.}

\item{seed}{int, default: 0.}

\item{verbose}{bool, default: TRUE. Enable verbose output.}
}
\value{
\item{eta}{estimated non-parametric part \eqn{\hat{\eta}(Z^T\boldmath{\hat{\alpha} })}.}
\item{zeta}{estimated coefficients. \code{zeta[1:ncol(z)]} is \eqn{\hat{\alpha}}, 
and \code{zeta[(ncol(z)+1):(ncol(z)+ncol(x))]} is \eqn{\hat{\beta}}.}
\item{data}{data information including \code{x}, \code{z}, \code{y}, bandwidth \code{h}, 
initial coefficients \code{zetaini} and iteration step \code{MaxStep}.}
\item{y_hat}{ \code{y}'s estimates.}
\item{mse}{mean squares erros between \code{y} and \code{y_hat}.}
\item{variance}{variance of \code{y_hat}.}
\item{r_square}{multiple correlation coefficient.}
\item{Z_alpha}{ \eqn{Z^T\boldmath{\hat{\alpha}}}.}
}
\description{
MAVE (Minimum Average Variance Estimation), proposed by Xia \emph{et al.} (2006)
to estimate parameters in PLSiM
\deqn{Y=\eta(Z^T\alpha)+X^T\beta+\epsilon.}
}
\examples{

# EXAMPLE 1 (INTERFACE=FORMULA)
# To estimate parameters in partially linear single-index model using MAVE.

n = 30
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

x = matrix(1,n,1)
z = matrix(runif(n*2),n,2)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

fit = plsim.MAVE(y~x|z, h=0.1)

# EXAMPLE 2 (INTERFACE=DATA FRAME)
# To estimate parameters in partially linear single-index model using MAVE.

n = 30
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")
beta = matrix(4,1,1)

x = rep(1,n)
z1 = runif(n)
z2 = runif(n) 
X = data.frame(x)
Z = data.frame(z1,z2)

x = data.matrix(X)
z = data.matrix(Z)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

fit = plsim.MAVE(xdat=X, zdat=Z, ydat=y, h=0.1)

}
\references{
Y. Xia, W. Härdle. \emph{Semi-parametric estimation of partially linear single-index models}.
Journal of Multivariate Analysis, 2006, 97(5): 1162-1184.
}
