% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runElbowPointAnalysis.R
\name{runElbowPointAnalysis}
\alias{runElbowPointAnalysis}
\title{Runs elbow point analysis to find the practical optimal number of clades to output. Outputs the average within sample cluster spread for all samples and the elbow point analysis plot with loess line fitted through the results.}
\usage{
runElbowPointAnalysis(ks, sampleIDs, dim_subset, num_PACSupop,
  smallSubpopCutoff, expressionGroupClamp, SubpopSizeFilter)
}
\arguments{
\item{ks}{Vector that is a sequence of clade sizes.}

\item{sampleIDs}{A vector of sample names.}

\item{dim_subset}{a string vector of string names to subset the data columns for PAC; set to NULL to use all columns.}

\item{num_PACSupop}{Number of PAC subpopulation explored in each sample.}

\item{smallSubpopCutoff}{Cutoff of minor subpopulation not used in multiple alignments of networks}

\item{expressionGroupClamp}{clamps the subpopulations into desired number of expression groups for assigning small subpopulations into larger groups or their own groups.}

\item{SubpopSizeFilter}{threshold to filter out very small clusters with too few points in the calculation of cluster spreads; these very small subpopulations may be outliers and not biologically relevant.}
}
\description{
Runs elbow point analysis to find the practical optimal number of clades to output. Outputs the average within sample cluster spread for all samples and the elbow point analysis plot with loess line fitted through the results.
}

