% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion.R
\name{disp}
\alias{disp}
\title{Outlier detection using genralised dispersion}
\usage{
disp(x, cutoff = 0.95, rnames = FALSE, boottimes = 100)
}
\arguments{
\item{x}{dataset for which outliers are to be found}

\item{cutoff}{Percentile threshold used for distance, default value is 0.95}

\item{rnames}{Logical value indicating whether the dataset has rownames, default value is False}

\item{boottimes}{Number of bootsrap samples to find the cutoff, default is 100 samples}
}
\value{
Outlier Observations: A matrix of outlier observations

Location of Outlier: Vector of Sr. no. of outliers

Outlier probability: Vector of proportion of times an outlier exceeds local bootstrap cutoff
}
\description{
Takes a dataset and find its outliers using dispersion-based method
}
\details{
disp computes LOO dispersion matrix for each observation(dispersion matrix without cosidering the current observation) and based on the bootstrapped cutoff for score(difference between determinant of LOO dispersion matrix and det of actual dispersion matrix), labels an observation as outlier. Outlierliness of the labelled 'Outlier' is also reported and it is the bootstrap estimate of probability of the observation being an outlier. For bivariate data, it also shows the scatterplot of the data with labelled outliers.
}
\examples{
#Create dataset
X=iris[,1:4]
#Outlier detection
disp(X,cutoff=0.99)
}
\references{
Jin, W., Tung, A., and Han, J. 2001. Mining top-n local outliers in large databases. In Proc. ACM SIGKDD Int. Conf. on Knowledge Discovery and Data Mining (SIGKDD), San Francisco, CA.
}
