% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/origami_plot.R
\name{origami_plot}
\alias{origami_plot}
\title{Function to generate origami plot}
\usage{
origami_plot(
  df,
  pcol,
  pfcol = NULL,
  axistype = 0,
  seg = 4,
  pty = 16,
  plty = 1:6,
  plwd = 1,
  pdensity = NULL,
  pangle = 45,
  cglty = 1.4,
  cglwd = 0.1,
  cglcol = "#000000",
  axislabcol = "#808080",
  title = "",
  na.itp = TRUE,
  centerzero = FALSE,
  vlabels = NULL,
  vlcex = 1,
  caxislabels = seq(0, 1, by = 0.25),
  calcex = NULL,
  paxislabels = NULL,
  palcex = NULL
)
}
\arguments{
\item{df}{dataset processed with data_preparation or in the designated form}

\item{pcol}{color of the line of the polygon}

\item{pfcol}{color to fill the area of the polygon, default is NULL.}

\item{axistype}{type of axes. 0:no axis label. 1:center axis label only. 2:around-the-chart label only. 3:both center and around-the-chart labels. Default is 0.}

\item{seg}{number of segments for each axis, default is 4.}

\item{pty}{point symbol, default is 16. 32 means not printing the points.}

\item{plty}{line types for plot data, default is 1:6}

\item{plwd}{line widths for plot data, default is 1}

\item{pdensity}{filling density of polygons, default is NULL}

\item{pangle}{angles of lines used as filling polygons, default is 45}

\item{cglty}{line type for radar grids, default is 1.4}

\item{cglwd}{line width for radar grids, default is 0.1}

\item{cglcol}{line color for radar grids, default is #000000}

\item{axislabcol}{color of axis label and numbers, default is #808080}

\item{title}{title of the chart, default is blank}

\item{na.itp}{logical. If true, items with NA values are interpolated from nearest neighbor items and connect them. If false, items with NA are treated as the origin. Default is TRUE.}

\item{centerzero}{logical. If true, this function draws charts with scaling originated from (0,0). If false, charts originated from (1/segments). Default is TRUE.}

\item{vlabels}{character vector for the names for variables, default is NULL}

\item{vlcex}{font size magnification for vlabels, default is 1}

\item{caxislabels}{center axis labels, default is seq(0,1,by = 0.25)}

\item{calcex}{font size magnification for caxislabels, default is NULL}

\item{paxislabels}{around-the-chart labels, default is NULL}

\item{palcex}{font size magnification for paxislabels, default is NULL}
}
\value{No return value, called for visualization}
\description{
Function to generate origami plot
}
\details{
This is the main function in the R package that takes a list of data frame(s) and constructs
an origami plot. The function plots the main axes of the radar chart as solid lines and marks the score of each
variable on these axes with a filled circle. Additionally, it plots auxiliary axes as dashed lines at equal distances
between each neighboring pair of primary axes with auxiliary points generated from data_preparation. Finally, the
function connects all the points in order and obtain a connected region that resembles an origami star. Through this
method, we successfully address the challenge of axis order affecting the area of the connected region in radar plots.
The plot generated using ‘origami_plot’ benefit in that the area of the connected region within the origami plot remains
 consistent regardless of axis sequence.
}
\examples{
data(sucra)
df_list <- data_preparation(sucra, min_value = 0.15)
origami_plot(df=df_list[[1]], pcol = rgb(0.2,0.5,0.5,1),
pfcol = rgb(0.2,0.5,0.5,0.1),axistype=1, pty = 32)

}
