% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/area_calculation.R
\name{area_calculation}
\alias{area_calculation}
\title{Function to calculate area of the generated polygon}
\usage{
area_calculation(df)
}
\arguments{
\item{df}{dataset processed with data_preparation or in the designated form}
}
\value{
area
}
\description{
Function to calculate area of the generated polygon
}
\details{
This function serves as a supplementary tool to compute the area of a generated origami
plot when the maximal area achievable within the defined parameters (when all the variables attain 1) is set to 1.
The resulting calculated area offers an interpretation of the proportion between the actual origami plot and the
maximum achievable area. An example of calculated area is shown in Figure 1.
}
\examples{
data(sucra)
df_list <- data_preparation(sucra, min_value = 0.15)
area_calculation(df_list[[1]])

}
