% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_taxonomy_general.R
\name{clean_tnrs}
\alias{clean_tnrs}
\title{Eliminates unmatched (NAs) and invalid taxa from a \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}} output.
Useful to get ott ids to retrieve an induced synthetic Open Tree of Life.
Needed because using \code{include_suppressed = FALSE} in \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} does not drop all invalid taxa.}
\usage{
clean_tnrs(
  tnrs,
  invalid = c("barren", "extinct", "uncultured", "major_rank_conflict", "incertae",
    "unplaced", "conflict", "environmental", "not_otu"),
  remove_nonmatches = FALSE
)
}
\arguments{
\item{tnrs}{A \code{data.frame}, usually an output from \code{\link[=tnrs_match]{tnrs_match()}} or \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}}, but see details.}

\item{invalid}{A character string with flags to be removed from final object.}

\item{remove_nonmatches}{Boolean, whether to remove unsuccessfully matched names or not.}
}
\value{
A \code{data.frame} or named list (depending on the input) with valid taxa only.
}
\description{
Eliminates unmatched (NAs) and invalid taxa from a \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}} output.
Useful to get ott ids to retrieve an induced synthetic Open Tree of Life.
Needed because using \code{include_suppressed = FALSE} in \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} does not drop all invalid taxa.
}
\details{
Input can be any data frame or named list that relates taxa stored in an element named "unique" to a validity category stored in "flags".
}
