% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{getN2}
\alias{getN2}
\title{Calculates the number of patients which should be enrolled in the second stage.}
\usage{
getN2(cp, p1, design, k, mode = 0, alpha = 0.05)
}
\arguments{
\item{cp}{conditional power to which the number of patients for the second stage should be adjusted.}

\item{p1}{response probability under the alternative hypothesis.}

\item{design}{a dataframe containing all critical values for a Simon's two-stage design defined by the colums r1, n1, r, n and p0.
\itemize{
   \item r1 = critical value for the first stage (more than r1 responses needed to proceed to the second stage).
   \item n1 = number of patients enrolled in the first stage.
   \item r = critical value for the whole trial (more than r responses needed at the end of the study to reject the null hypothesis).
   \item n = number of patients enrolled in the whole trial.
   \item p0 = response probability under the null hypothesis.
}}

\item{k}{number of responses observed at the interim analysis.}

\item{mode}{a value out of \{0,1,2,3\} dedicating the methode spending the "rest alpha" (difference between nominal alpha level and actual alpha level for the given design).
\itemize{
   \item 0 = "rest alpha" is not used.
   \item 1 = "rest alpha" is spent proportionally.
   \item 2 = "rest alpha" is spent equally.
   \item 3 = "rest alpha" is spent only to the worst case scenario (minimal number of responses at the interim analysis so that the study can proceed to the second stage).
}}

\item{alpha}{overall significance level the trial was planned for.}
}
\description{
Calculates the number of patients which should be enrolled in the second stage if the conditional power should be altert to "cp".
}
\examples{
\dontrun{
#Calculate a Simon's two-stage design
design <- getSolutions()$Solutions[3,] #minimax-design for the default values.

#Assume we only observed 3 responses in the interim analysis.
#Therefore the conditional power is only about 0.55.
#In order to raise the conditional power to 0.8 "n2" has to be increased.

#set k to 3 (only 3 responses observed so far)
k = 3

# Assume we spent the "rest alpha" proportionally in the planning phase
# there for we set "mode = 1".
n2 <- getN2(cp = 0.8, design$p1, design, k, mode = 1, alpha = 0.05)
n2
}
}
\references{
Englert S., Kieser M. (2012): Adaptive designs for single-arm phase II trials in oncology. Pharmaceutical Statistics 11,241-249.
}

