% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_linpred.R
\name{posterior_linpred.blrmfit}
\alias{posterior_linpred.blrmfit}
\alias{posterior_linpred}
\title{Posterior of linear predictor}
\usage{
\method{posterior_linpred}{blrmfit}(object, transform = FALSE, newdata, draws, ...)
}
\arguments{
\item{object}{fitted model object}

\item{transform}{logical (defaults to \code{FALSE}) indicating if
the linear predictor on the logit link scale is transformed
with \code{inv_logit} to the 0-1 response scale.}

\item{newdata}{optional data frame specifying for what to predict;
if missing, then the data of the input model \code{object} is
used}

\item{draws}{number of returned posterior draws; by default the
entire posterior is returned}

\item{...}{not used in this function}
}
\value{
Matrix of dimensions \code{draws} by \code{nrow(newdata)}
where row correspond to a draw of the posterior and each
column corresponds to a row in \code{newdata}. The columns are
labelled with the \code{row.names} of \code{newdata}.
}
\description{
Calculates the posterior of the linear predictor.
}
\details{
Simulates the posterior of the linear predictor of the model
\code{object} for the specified data set.
}
\section{Group and strata definitions}{


The groups and strata as defined when running the \code{blrm_exnex}
analysis cannot be changed at a later stage. As a result no
evaluations can be performed for groups which have not been present
in the data set used for running the analysis. However, it is
admissible to code the group (and/or stratum) column as a
\code{factor} which contains empty levels. These groups are thus
not contained in the fitting data set and they are assigned by
default to the first stratum. In addition priors must be setup for
these groups (and/or strata). These empty group (and/or strata)
levels are then allowed in subsequent evaluations. This enables the
evaluation of the hierarchical model in terms of representing a
prior for future groups.
}

\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(
  OncoBayes2.MC.warmup = 10, OncoBayes2.MC.iter = 20, OncoBayes2.MC.chains = 1,
  OncoBayes2.MC.save_warmup = FALSE
)


## run single-agent analysis which defines blrmfit model object
example_model("single_agent", silent = TRUE)

## obtain posterior of linear prediction on 0-1 scale
post_prob_dlt <- posterior_linpred(blrmfit, TRUE, newdata = hist_SA)
## name columns to obtain nice bayesplot labels
colnames(post_prob_dlt) <- hist_SA$drug_A

library(bayesplot)
library(ggplot2)
mcmc_intervals(post_prob_dlt, prob = 0.5, prob_outer = 0.95) +
  coord_flip() +
  vline_at(c(0.16, 0.33), linetype = 2) +
  ylab("Dose [mg]") +
  ggtitle("Posterior Probability of a DLT") +
  scale_x_continuous(breaks = c(0.1, 0.16, 0.33, 0.5, 0.75))

## Recover user set sampling defaults
options(.user_mc_options)

}
