% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\name{loocv}
\alias{loocv}
\title{K fold CV for O2PLS}
\usage{
loocv(X, Y, a = 1:2, a2 = 1, b2 = 1, fitted_model = NULL,
  func = o2m, app_err = F, kcv, stripped = TRUE, p_thresh = 3000,
  q_thresh = p_thresh, tol = 1e-10, max_iterations = 100)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{a}{Vector of integers. Contains the numbers of joint components.}

\item{a2}{Vector of integers. Contains the numbers of orthogonal components in \eqn{X}.}

\item{b2}{Vector of integers. Contains the numbers of orthogonal components in \eqn{Y}.}

\item{fitted_model}{List. O2PLS model fit with \code{\link{o2m}}. Is used to calculate the apparent error without recalculating this fit.}

\item{func}{Function to fit the O2PLS model with. Only \code{\link{o2m}} and \code{\link{o2m_stripped}} are supported.}

\item{app_err}{Logical. Should the apparent error also be computed? Not used anymore.}

\item{kcv}{Integer. The value of \eqn{k}, i.e. the number of folds. Choose \eqn{N} for LOO-CV.}

\item{stripped}{Logical. Use the stripped version of o2m (usually when cross-validating)?}

\item{p_thresh}{Integer. If \code{X} has more than \code{p_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{q_thresh}{Integer. If \code{Y} has more than \code{q_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{tol}{double. Threshold for power method iteration}

\item{max_iterations}{Integer, Maximum number of iterations for power method}
}
\value{
List with two numeric vectors:
\item{CVerr}{Contains the k-fold CV estimated RMSEP}
\item{Fiterr}{Contains the apparent error}
}
\description{
For (a grid of) values for \code{a}, \code{nx} and \code{ny}, \code{loocv} estimates the prediction error using k-fold CV.
}
\details{
Note that this function can be easily parallelized (on Windows e.g. with the \code{parallel} package.).

The parameters \code{a}, \code{a2} and \code{b2} can be integers or vectors of integers. A for loop is used to loop over all combinations.
The resulting output is a list, which is more easy to interpret if you use \code{array(unlist(output_of_loocv$CVerr))} as in the example below.
The array wil have varying \code{a} along the first dimension and \code{a2} and \code{b2} along the second and third respectively.
Typing \code{example(loocv)} (hopefully) clarifies this function.
}
