% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset.R
\name{getResultsIntersection}
\alias{getResultsIntersection}
\title{getResultsIntersection}
\usage{
getResultsIntersection(
  study,
  modelID,
  anchor,
  mustTests,
  notTests,
  sigValue,
  operator,
  column
)
}
\arguments{
\item{study}{An OmicNavigator study. Either an object of class \code{onStudy},
or the name of an installed study package.}

\item{modelID}{Filter by modelID}

\item{anchor}{The primary testID to filter the results}

\item{mustTests}{The testIDs for which a featureID (or termID for enrichment)
must pass the filters}

\item{notTests}{The testIDs for which a featureID (or termID for enrichment)
must \bold{not} pass the filters. In other words, if a featureID passes the
filter for a testID specified in notTests, that featureID is removed from
the output}

\item{sigValue}{The numeric significance value to use as a cutoff for each
column}

\item{operator}{The comparison operators for each column, e.g. \code{"<"}}

\item{column}{The columns to apply the filters}
}
\value{
Returns a data frame with the results, similar to
  \code{\link{getResultsTable}}. Only rows that pass all the filters are
  included. The new column \code{Set_Membership} is a comma-separated field
  that includes the testIDs in which the featureID passed the filters.
}
\description{
getResultsIntersection
}
\seealso{
\code{\link{getResultsTable}}
}
