% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ResamplePlot}
\alias{ResamplePlot}
\title{A function to plot the results of resampling methods}
\usage{
ResamplePlot(ResampleTest, var = 1, coldist = 'red', colind = 'blue', 
legend = TRUE, legendpos = 'top', cex.legend = 1, bty = 'o')
}
\arguments{
\item{ResampleTest}{- a ResampleTest object prodused with \code{\link{ResampleTest}} function}

\item{var}{- the number of the variable to be plot}

\item{coldist}{- color used to plot the simulated distribution}

\item{colind}{- color used to plot the index}

\item{legend}{- logical parameter, to control the legend's plots}

\item{legendpos}{- a character string giving the legend's position: 
'bottomright', 'bottom', 'bottomleft', 'left', 'topleft', 'top', 
'topright', 'right' and 'center'.}

\item{cex.legend}{- a numerical value giving the amount by which 
plotting text and symbols in legend should be magnified relative to the default.}

\item{bty}{- a character string which determines the type of box 
of the legend. If bty is one of 'o' (the default), 'l', '7', 'c', 
'u', or ']' the resulting box resembles the corresponding upper 
case letter. A value of 'n' suppresses the box.}
}
\value{
A plot with resampling distribution
}
\description{
Plot of Monte Carlo simulations results. The function can
be used in two ways: buy providing a ResampleTest object, using \code{\link{ResampleTest}} 
or a simulated distribution vector, a value and a name of the index
}
\examples{
x <- segdata@data[ ,1:2]

xtest <- ResampleTest (x, fun ='ISMorrill', simtype = 'MonteCarlo', 
                       sampleunit = 'unit', spatobj = segdata)
                       
ResamplePlot(xtest, var = 1)

}
\references{
Tivadar M., Schaeffer Y, Torre A. and Bray F. (2014) 
\emph{OASIS - un Outil d'Analyse de la Segregation et des Inegalites 
Spatiales}.  Cybergeo : European Journal of Geography, GeOpenMod, 
document 699
}
\seealso{
\code{\link{ResampleTest}}
}
