% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{DMulti}
\alias{DMulti}
\title{A function to compute multigroup dissimilarity index}
\usage{
DMulti(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
Multigroup dissimilarity index
}
\description{
Multigroup version of dissimilarity index
(\code{\link{DI}})
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
DMulti(x)
}
\references{
Sakoda J. N. (1981) \emph{A generalized Index of
dissimilarity}. Demography,18, 245-250
}
\seealso{
Other multigroup eveness indices:
\code{\link{HShannon}}, \code{\link{JPielou}}, \code{\link{ISimpson}},
\code{\link{GiniMulti}}

Other multigroup indices: \code{\link{PIsol}},
\code{\link{RelDivers}}
}

