% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComparePcaPlots.R
\name{ComparePcaPlots}
\alias{ComparePcaPlots}
\title{Compare PCA Plots}
\usage{
ComparePcaPlots(lfeaturedata, lgroupdata, saveplot = FALSE, plotname = "",
  savetype = c("png", "bmp", "jpeg", "tiff", "pdf"), y.axis = 1,
  x.axis = 2, center = TRUE, scale = TRUE, lmain = NULL, n = 3,
  cols = NULL, cex_val = 0.7, ...)
}
\arguments{
\item{lfeaturedata}{A list of data frames in the featuredata format. 
This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.
See NormalizeMets Vignette for details.}

\item{lgroupdata}{A list of data frames or a vectors with group names.}

\item{saveplot}{A logical indication whether to save the plot produced.}

\item{plotname}{Name of the output file if the file is to be saved. This is
the general name for all the graphs and the specific type prefix will be
added automatically.}

\item{savetype}{The required format for the plot to be saved in. Threre is a
choice of \code{"png","bmp","jpeg","tiff","pdf"} type files.}

\item{y.axis}{The principal component to be plotted on the \emph{y}-axis.}

\item{x.axis}{The principal component to be plotted on the \emph{x}-axis.}

\item{center}{A logical indicating whether the variables should be scaled to
have zero mean.}

\item{scale}{A logical indicating whether the variables should be scaled to
have unit variance before the analysis takes place.}

\item{lmain}{A list of plot titles}

\item{n}{The number of principal components to be plotted. The default value is set to 3.}

\item{cols}{A character string with colours to be used.}

\item{cex_val}{A numeric indicating the size of some text elements.}

\item{...}{Arguments to be passed on to other methods.}
}
\description{
Produces a comparison of principal component multiplots
}
\examples{

    data(mixdata)
    ComparePcaPlots(list(mixdata$featuredata,mixdata$featuredata*1.2),
             list(mixdata$sampledata[,3],mixdata$sampledata[,3])) 

}
\author{
Alysha M De Livera, Gavriel Olshansky.
}
