\name{nlFitStart}
\alias{nlFitStart}
\alias{nlFitStartMoM}

\title{Find Starting Values for Fitting a Normal Laplace Distribution}
\description{
  Finds starting values for input to a maximum likelihood routine for
  fitting a normal Laplace distribution to data.
}

\usage{
  nlFitStart(x, breaks = "FD",
             paramStart = NULL,
             startValues = c("MoM", "US"),
             startMethodMoM = "Nelder-Mead", ...)
  nlFitStartMoM(x, startMethodMoM = "Nelder-Mead", ...)
}

\arguments{
  \item{x}{Data vector.}
  \item{breaks}{Breaks for histogram. If missing, defaults to those
    generated by
    \code{hist(x, right = FALSE, plot = FALSE)}.}
  \item{paramStart}{Starting values for parameter vector if
    \code{startValues = "US"}.}
  \item{startValues}{Vector of the different starting value methods
    to consider.
    See \bold{Details}.}
  \item{startMethodMoM}{Method used by call to \code{\link{optim}} in
    finding method of moments estimates.}
  \item{\dots}{Passes arguments to \code{\link{optim}}.}
}

\details{
  Possible values of the argument \code{startValues} are the following:
  \itemize{
    \item{\code{"US"}}{User-supplied.}
    \item{\code{"MoM"}}{Method of moments.}
  }

  If \code{startValues = "US"} then a value must be supplied for
  \code{paramStart}.

  If \code{startValues = "MoM"}, \code{nlFitStartMoM} is
  called.

  If \code{startValues = "MoM"} an initial optimisation is needed to find
  the starting values. These optimisations call \code{\link{optim}}.
}

\value{
  \code{nlFitStart} returns a list with components:
    \item{paramStart}{A vector with elements \code{mu}, \code{sigma},
      \code{alpha} and \code{beta} giving the starting value of param.}
    \item{xName}{A character string with the actual \code{x} argument name.}
    \item{breaks}{The cell boundaries found by a call to
      \code{\link{hist}}.}
    \item{midpoints}{The cell midpoints found by a call to
      \code{\link{hist}}.}
    \item{empDens}{The estimated density found by a call to
      \code{\link{hist}}.}

  \code{nlFitStartMoM} returns only the method of moments estimates
    as a vector with elements \code{mu}, \code{sigma}, \code{alpha} and
    \code{beta}.
}

\author{David Scott \email{d.scott@auckland.ac.nz},
  Simon Potter}

\seealso{
  \code{\link{dnl}}, \code{\link{nlFit}}, \code{\link{hist}}, and
  \code{\link{optim}}.
}

\examples{
param <- c(2, 2, 1, 1)
dataVector <- rnl(500, param = param)
nlFitStart(dataVector, startValues = "MoM")
}

\keyword{distribution}
