% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvtGLomax.R
\name{MvtGlomx}
\alias{MvtGlomx}
\alias{dmvglomax}
\alias{pmvglomax}
\alias{qmvglomax}
\alias{rmvglomax}
\alias{smvglomax}
\title{Generalized Multivariate Lomax (Pareto Type II) Distribution}
\usage{
dmvglomax(x, parm1 = 1, parm2 = rep(1, k), parm3 = rep(1, k), log = FALSE)

pmvglomax(
  q,
  parm1 = 1,
  parm2 = rep(1, k),
  parm3 = rep(1, k),
  algorithm = c("numerical", "MC"),
  nsim = 1e+07
)

qmvglomax(
  p,
  parm1 = 1,
  parm2 = rep(1, k),
  parm3 = rep(1, k),
  interval = c(1e-08, 1e+08),
  algorithm = c("numerical", "MC"),
  nsim = 1e+06
)

rmvglomax(n, parm1 = 1, parm2 = rep(1, k), parm3 = rep(1, k))

smvglomax(
  q,
  parm1 = 1,
  parm2 = rep(1, k),
  parm3 = rep(1, k),
  algorithm = c("numerical", "MC"),
  nsim = 1e+07
)
}
\arguments{
\item{x}{vector or matrix of quantiles. If \eqn{x} is a matrix, each row vector constitutes a vector of quantiles for which the density \eqn{f(x)} is calculated (for \eqn{i}-th row \eqn{x_i}, \eqn{f(x_i)} is reported).}

\item{parm1}{a scalar parameter, see parameter \eqn{a} in \strong{Details}.}

\item{parm2}{a vector of parameters, see parameters \eqn{\theta_i} in \strong{Details}.}

\item{parm3}{a vector of parameters, see parameters \eqn{l_i} in \strong{Details}.}

\item{log}{logical; if TRUE, probability densities \eqn{f} are given as \eqn{log(f)}.}

\item{q}{a vector of quantiles.}

\item{algorithm}{method to be used for calculating cumulative probability. Two options are provided as (i) \code{numerical} using adaptive multivariate integral and (ii) \code{MC} using Monte Carlo method. Recommend algorithm \code{numerical} for \eqn{(k <= 4)} dimension and \code{MC} for \eqn{(k > 4)} dimension based on running time consumption. Default option is set as \code{numerical}.}

\item{nsim}{number of simulations used in algorithm \code{MC}.}

\item{p}{a scalar value corresponding to probability.}

\item{interval}{a vector containing the end-points of the interval to be searched. Default value is set as \code{c(1e-8, 1e8)}.}

\item{n}{number of observations.}

\item{k}{dimension of data or number of variates.}
}
\value{
\code{dmvglomax} gives the numerical values of the probability density.

\code{pmvglomax} gives a list of two items:

\eqn{\quad} \code{value} cumulative probability

\eqn{\quad} \code{error} the estimated relative error by \code{algorithm = "numerical"} or the estimated standard error by \code{algorithm = "MC"}

\code{qmvglomax} gives the equicoordinate quantile. \code{NaN} is returned for no solution found in the given interval. The result is seed dependent if Monte Carlo algorithm is chosen  (\code{algorithm = "MC"}).

\code{rmvglomax} generates random numbers.

\code{smvglomax} gives a list of two items:

\eqn{\quad} \code{value} the value of survial function

\eqn{\quad} \code{error} the estimated relative error by \code{algorithm = "numerical"} or the estimated standard error by \code{algorithm = "MC"}
}
\description{
Calculation of density function, cumulative distribution function, equicoordinate quantile function and survival function, and random numbers generation for generalized multivariate Lomax distribution with a scalar parameter \code{parm1} and vectors of parameters \code{parm2} and \code{parm3}.
}
\details{
Generalized multivariate Lomax (Pareto type II) distribution was introduced by Nayak (1987) as a joint probability distribution of several skewed nonnegative random variables \eqn{X_1, X_2, \cdots, X_k}. Its probability density function is given by
\deqn{f(x_1, \cdots, x_k) = \frac{[ \prod_{i=1}^{k} \theta_i^{l_i}] \Gamma(\sum_{i=1}^{k} l_i + a ) \prod_{i=1}^{k} x_i^{l_i-1}}{\Gamma(a)[ \prod_{i=1}^{k} \Gamma(l_i)] (1+\sum_{i=1}^{k} \theta_i x_i )^{\sum_{i=1}^{k} l_i + a}},}
where \eqn{x_i>0, a,\theta_i, l_i>0, i=1,\cdots,k}.

Cumulative distribution function \eqn{F(x_1, \dots, x_k)} is obtained by multiple integral
\deqn{F(x_1, \dots, x_k) = \int_{0}^{x_1} \cdots  \int_{0}^{x_k} f(y_1, \cdots, y_k) dy_k \cdots dy_1.}
This multiple integral is calculated by either adaptive multivariate integration using \code{\link{hcubature}} in package \strong{\link{cubature}} (Narasimhan et al., 2018) or via Monte Carlo method.

Equicoordinate quantile is obtained by solving the following equation for \eqn{q} through the built-in one dimension root finding function \code{\link{uniroot}}:
\deqn{\int_{0}^{q} \cdots \int_{0}^{q} f(x_1, \cdots, x_k) dx_k \cdots dx_1 = p,}
where \eqn{p} is the given cumulative probability.

The survival function \eqn{\bar{F}(x_1, \cdots, x_k)} is obtained either by the following formula related to cumulative distribution function \eqn{F(x_1, \dots, x_k)} (Joe, 1997)
\deqn{\bar{F}(x_1, \cdots, x_k) = 1 + \sum_{S \in \mathcal{S}} (-1)^{|S|} F_S(x_j, j \in S),}
or via Monte Carlo method.

Random numbers from generalized multivariate Lomax distribution can be generated by simulating \eqn{k} independent gamma random variables having a common parameter following gamma distribution with shape parameter \eqn{a} and scale parameter \eqn{1}; see Nayak (1987).
}
\examples{
# Calculations for the generalized multivariate Lomax with parameters:
# a = 5, theta1 = 1, theta2 = 2, l1 = 4, l2 = 5
# Vector of quantiles: c(5, 6)

dmvglomax(x = c(5, 6), parm1 = 5, parm2 = c(1, 2), parm3 = c(4, 5)) # Density


# Cumulative Probability using adaptive multivariate integral
pmvglomax(q = c(5, 6), parm1 = 5, parm2 = c(1, 2), parm3 = c(4, 5))

\donttest{
# Cumulative Probability using Monte Carlo method
pmvglomax(q = c(5, 6), parm1 = 5, parm2 = c(1, 2), parm3 = c(4, 5), algorithm = "MC")}

\donttest{
# Equicoordinate quantile of cumulative probability 0.5
qmvglomax(p = 0.5, parm1 = 5, parm2 = c(1, 2), parm3 = c(4, 5))}

# Random numbers generation with sample size 100
rmvglomax(n = 100, parm1 = 5, parm2 = c(1, 2), parm3 = c(4, 5))

smvglomax(q = c(5, 6), parm1 = 5, parm2 = c(1, 2), parm3 = c(4, 5)) # Survival function

}
\references{
Joe, H. (1997). \emph{Multivariate Models and Dependence Concepts}. London: Chapman & Hall.

Narasimhan, B.,  Koller, M., Johnson, S. G., Hahn, T., Bouvier, A., Kiêu, K. and Gaure, S. (2018). cubature: Adaptive Multivariate Integration over Hypercubes. R package version 2.0.3.

Nayak, T. K. (1987). Multivariate Lomax Distribution: Properties and Usefulness in Reliability Theory. \emph{Journal of Applied Probability}, Vol. 24, No. 1, 170-177.
}
\seealso{
\code{\link{uniroot}} for one dimensional root (zero) finding.
}
