% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modues.R
\name{mi_cont}
\alias{mi_cont}
\title{Continuous  Mutual Information}
\usage{
mi_cont(X, Y, k = 3, algo = "ksg1", normalize = FALSE)
}
\arguments{
\item{X}{Integer vector, first time series.}

\item{Y}{Integer vector, the second time series.}

\item{k}{Integer argument, the number of neighbors.}

\item{algo}{String argument specifies the algorithm use ("ksg1", "ksg2"), as tow propositions of Kraskov estimation are provided. The first one ("ksg1") is used by default.}

\item{normalize}{Logical argument (FALSE by default)  for the option of normalizing the mutual information by dividing it by the joint entropy.}
}
\description{
Continuous  Mutual Information
}
\details{
Computes the   Mutual Information between two vectors using the Kraskov estimator.
}
\examples{
library (timeSeries)
library (NlinTS)
#load data
data = LPP2005REC
print (mi_cont (data[,1], data[,2], 3, 'ksg1'))
print (mi_cont (data[,1], data[,2], 3, 'ksg2'))
}
\references{
{
  \insertRef{kraskov2004estimating}{NlinTS}
}
}
