% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_select_k_features.R
\name{preprocess_data.fp_select_k_features}
\alias{preprocess_data.fp_select_k_features}
\title{A feature-preprocessor (FP) method to pre-process training and test data}
\usage{
\method{preprocess_data}{fp_select_k_features}(fp, training_set, test_set)
}
\arguments{
\item{fp}{The FP object.}

\item{training_set}{The training set data from one time bin. This is a data
frame where the rows correspond to data from a given trial. There must be a
column called \code{train_labels} that has the labels of what occurred on each
trial. The rest of the  columns correspond to the neural activity of a
particular site on each trial (and typically have names like site_0001,
site_0002, etc).}

\item{test_set}{The test set data from all times. This is a data frame where
the rows correspond to data from a given trial. There must be a column
called \verb{time_ bin} that contains a label indicating the time point that a
row (test point) came from.  The rest of the  columns correspond to the
neural activity of a particular site on each test trial (and typically have
names like site_0001, site_0002, etc).}
}
\value{
A list is returned that contains two data frames called
\code{training_set} and \code{test_set} which contain data in the same format as the
\code{training_set} and \code{test_set} arguments passed to this function, however
the data in these data frames has been processed by the FP object.
}
\description{
This is a function that must be implemented by all FP objects. This object
learns a set of parameters from the training data (i.e., the data generated
from a datasource get_data() method). The \code{preprocess_data()} method then
uses these parameters do processing on the training and test data before the
data is sent to the classifier. This method should not be called directly but
instead it is used internally by the cross-validator (CV) object.
}
\seealso{
\code{\link[=fp_zscore]{fp_zscore()}}, \code{\link[=fp_select_k_features]{fp_select_k_features()}}
}
\keyword{internal}
