% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/louvain.R
\name{louvain}
\alias{louvain}
\title{Louvain Community Detection Algorithm}
\usage{
louvain(A, gamma, M0)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{gamma}{Defaults to \code{1}.
Set to \code{gamma} > 1 to detect smaller modules and \code{gamma} < 1 for larger modules}

\item{M0}{Input can be an initial community vector.
Defaults to \code{NULL}}
}
\value{
Returns a list containing:

\item{community}{A community vector corresponding to each node's community}

\item{Q}{Modularity statistic. A measure of how well the communities are comparmentalized}
}
\description{
Computes a vector of communities (community) and a global modularity measure (Q)
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

modularity <- louvain(A)

}
\references{
Blondel, V. D., Guillaume, J. L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks. 
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2008}, P10008.
doi: \href{https://doi.org/10.1088/1742-5468/2008/10/P10008}{10.1088/1742-5468/2008/10/P10008}
 
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
