% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depna.R
\name{depna}
\alias{depna}
\title{Dependency Neural Networks}
\usage{
depna(neuralarray, pB = TRUE, ...)
}
\arguments{
\item{neuralarray}{Array from \code{\link{convertConnBrainMat}} function}

\item{pB}{Should progress bar be displayed?
Defaults to \code{TRUE}.
Set \code{FALSE} for no progress bar}

\item{...}{Additional arguments from \code{\link{depend}} function}
}
\value{
Returns an array of n x n x m dependency matrices
}
\description{
Applies the dependency network approach to neural network array
}
\examples{
\dontrun{
neuralarray <- convertConnBrainMat()

dependencyneuralarray <- depna(neuralarray)
}

}
\references{
Jacob, Y., Winetraub, Y., Raz, G., Ben-Simon, E., Okon-Singer, H., Rosenberg-Katz, K., ... & Ben-Jacob, E. (2016).
Dependency Network Analysis (DEPNA) reveals context related influence of brain network nodes.
\emph{Scientific Reports}, \emph{6}, 27444.
doi: \href{https://doi.org/10.1038/srep27444}{10.1038/srep27444}

Kenett, D. Y., Tumminello, M., Madi, A., Gur-Gershgoren, G., Mantegna, R. N., & Ben-Jacob, E. (2010).
Dominating clasp of the financial sector revealed by partial correlation analysis of the stock market.
\emph{PloS one}, \emph{5}, e15032.
doi: \href{https://doi.org/10.1371/journal.pone.0015032}{10.1371/journal.pone.0015032}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
