% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.coverage.R
\name{net.coverage}
\alias{net.coverage}
\title{Network Coverage}
\usage{
net.coverage(A, nodes, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix}

\item{nodes}{Subset of nodes to examine the coverage of the network}

\item{weighted}{Is the network weighted?
Defaults to FALSE.
Set to TRUE for weighted measures}
}
\value{
Returns a list containing:

\item{mean}{The average distance from the subset of nodes to all other nodes in the network}

\item{sd}{The standard deviation of distance from the subset of nodes to all other nodes in the network}

\item{range}{The range of distance from the subset of nodes to all other nodes in the network}
}
\description{
Computes the mean distance across a subset of nodes in a network.
This measure can be used to identify the effectiveness of a subset of nodes'
coverage of the network space
}
\examples{
A <- TMFG(neoOpen)$A

nodes <- c(1,3,5,7,11,13,17,19,23,29,31,37,41,43,47)

result <- net.coverage(A, nodes)

}
\references{
Christensen, A. P., Cotter, K. N., Silvia, P. J., & Benedek, M. (2018)
Scale development via network analysis: A comprehensive and concise measure of Openness to Experience
\emph{PsyArXiv}, 1-40.
doi: \href{https://doi.org/10.31234/osf.io/3raxt}{10.31234/osf.io/3raxt}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
Mathias Benedek <mathias.benedek@uni-graz.at>
}
