% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closeness.R
\name{closeness}
\alias{closeness}
\title{Closeness Centrality}
\usage{
closeness(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to TRUE.
Set to FALSE for unweighted measure of closeness centrality}
}
\value{
A vector of closeness centrality values for each node in the network
}
\description{
Computes closeness centrlaity of each node in a network
}
\examples{
A <- TMFG(neoOpen)$A

#Weighted LC
LC <- closeness(A)

#Unweighted LC
LC <- closeness(A, weighted = FALSE)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
