% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{neuralstat}
\alias{neuralstat}
\title{Local and Global Neural Network Characteristics}
\usage{
neuralstat(filarray, statistic = c("CC", "ASPL", "Q", "S", "transitivity",
  "conn", "BC", "LC", "deg", "inDeg", "outDeg", "degRI", "str", "inStr",
  "outStr", "strRI", "comm", "EC", "lev", "rspbc", "hybrid", "impact"),
  progBar = TRUE, ...)
}
\arguments{
\item{filarray}{Filtered array from \code{\link{neuralnetfilter}} function}

\item{statistic}{A statistic to compute}

\item{progBar}{Should progress bar be displayed? Defaults to TRUE. Set FALSE for no progress bar}

\item{...}{Additional arguments for statistics functions}
}
\value{
Returns vector of global characteristics (rows = participants, columns = statistic) or a matrix of local characteristics (rows = ROIs, columns = participants)
}
\description{
Obtains a global or local network characteristic from neural network data
}
\examples{
\dontrun{
neuralarray <- convertConnBrainMat()

filteredneuralarray <- neuralnetfilter(neuralarray, method = "threshold", thres = .50)

ClusteringCoefficient <- neuralstat(filteredneuralarray, statistic = "CC")

AverageShortestPathLength <- neuralstat(filteredneuralarray, statistic = "ASPL")

Modularity <- neuralstat(filteredneuralarray, statistic = "Q")

Smallworldness <- neuralstat(filteredneuralarray, statistic = "S")

Trasitivity <- neuralstat(filteredneuralarray, statistic = "transitivity")

Connectivity <- neuralstat(filteredneuralarray, statistic = "conn")

BetweennessCentrality <- neuralstat(filteredneuralarray, statistic = "BC")

ClosenessCentrality <- neuralstat(filteredneuralarray, statistic = "LC")

Degree <- neuralstat(filteredneuralarray, statistic = "deg")

NodeStrength <- neuralstat(filteredneuralarray, statistic = "str")

Communities <- neuralstat(filteredneuralarray, statistic = "comm")

EigenvectorCentrality <- neuralstat(filteredneuralarray, statistic = "EC")

LeverageCentrality <- neuralstat(filteredneuralarray, statistic = "lev")

RandomShortestPathBC <- neuralstat(filteredneuralarray, statistic = "rspbc")

HybridCentrality <- neuralstat(filteredneuralarray, statistic = "hybrid")

NodeImpact <- neuralstat(filteredneuralarray, statistic = "impact")
}
}
\references{
Blondel, V. D., Guillaume, J. L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks. 
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2008}(10), P10008.

Joyce, K. E., Laurienti, P. J., Burdette, J. H., & Hayasaka, S. (2010).
A new measure of centrality for brain networks. 
\emph{PLoS One}, \emph{5}(8), e12200.

Kenett, Y. N., Kenett, D. Y., Ben-Jacob, E., & Faust, M. (2011).
Global and local features of semantic networks: Evidence from the Hebrew mental lexicon.
\emph{PloS one}, \emph{6}(8), e23912.

Kivimaki, I., Lebichot, B., Saramaki, J., & Saerens, M. (2016).
Two betweenness centrality measures based on Randomized Shortest Paths.
\emph{Scientific Reports}, \emph{6}(19668), 1-15.

Pozzi, F., Di Matteo, T., & Aste, T. (2013).
Spread of risk across financial markets: Better to invest in the peripheries. 
\emph{Scientific Reports}, \emph{3}(1655), 1-7.

Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
